/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    dma_ex02_adc_soc_continuous_pwm_board.h
*   @brief   
*
*/

#ifndef DMA_EX02_ADC_SOC_CONTINUEOUS_PWM_BOARD_H_
#define DMA_EX02_ADC_SOC_CONTINUEOUS_PWM_BOARD_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

//
// Defines for debug UART
//
#if __arm__
#define SCI_BASE 		(SCIB_BASE)
#else
#define SCI_BASE 		(SCIA_BASE)
#endif

//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************
#define testADC_INT_NUMBER         (ADC_INT_NUMBER3)
#define testADC_BASE               (ADCA_BASE)
#define testADC_RESULT             (ADCARESULT_BASE)
#define testDMAMUX_Request_ID      (DMAMUX_ReqId_Trig_ADCA_3int)
#define testDMAMUX_Request_ID_Evt  (DMAMUX_ReqId_Trig_ADCA_evt_int)
#define testADC_CH                 (ADC_CH_ADCIN11)

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void Board_init();
void PinMux_init();
/**
 * \brief   "add brief description of this function" 
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */


#ifdef __cplusplus
}
#endif


#endif /* DMA_EX02_ADC_SOC_CONTINUEOUS_PWM_BOARD_H_ */
