/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    dma_ex03_epwm_puty_change_board.h
*   @brief   
*
*/

#ifndef DMA_EX03_EPWM_PUTY_CHANGE_BOARD_H_
#define DMA_EX03_EPWM_PUTY_CHANGE_BOARD_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "xbar.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

//
// Defines for debug UART
//
#if __arm__
#define SCI_BASE 		(SCIA_BASE)
#else
#define SCI_BASE 		(SCIA_BASE)
#endif

//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

//
// EPWM1 -> myEPWM1 Pinmux
//
//
// EPWM1_A - GPIO Settings
//
#define GPIO_PIN_EPWM1_A 0
#define myEPWM1_EPWMA_GPIO 0
#define myEPWM1_EPWMA_PIN_CONFIG GPIO_0_EPWM1_A
//
// EPWM1_B - GPIO Settings
//
#define GPIO_PIN_EPWM1_B 1
#define myEPWM1_EPWMB_GPIO 1
#define myEPWM1_EPWMB_PIN_CONFIG GPIO_1_EPWM1_B

//
// EPWM2 -> myEPWM2 Pinmux
//
//
// EPWM2_A - GPIO Settings
//
#define GPIO_PIN_EPWM2_A 2
#define myEPWM2_EPWMA_GPIO 2
#define myEPWM2_EPWMA_PIN_CONFIG GPIO_2_EPWM2_A
//
// EPWM2_B - GPIO Settings
//
#define GPIO_PIN_EPWM2_B 3
#define myEPWM2_EPWMB_GPIO 3
#define myEPWM2_EPWMB_PIN_CONFIG GPIO_3_EPWM2_B

//
// EPWM3 -> myEPWM3 Pinmux
//
//
// EPWM3_A - GPIO Settings
//
#define GPIO_PIN_EPWM3_A 4
#define myEPWM3_EPWMA_GPIO 4
#define myEPWM3_EPWMA_PIN_CONFIG GPIO_4_EPWM3_A
//
// EPWM3_B - GPIO Settings
//
#define GPIO_PIN_EPWM3_B 5
#define myEPWM3_EPWMB_GPIO 5
#define myEPWM3_EPWMB_PIN_CONFIG GPIO_5_EPWM3_B

//
// EPWM4 -> myEPWM4 Pinmux
//
//
// EPWM4_A - GPIO Settings
//
#define GPIO_PIN_EPWM4_A 6
#define myEPWM4_EPWMA_GPIO 6
#define myEPWM4_EPWMA_PIN_CONFIG GPIO_6_EPWM4_A
//
// EPWM4_B - GPIO Settings
//
#define GPIO_PIN_EPWM4_B 5
#define myEPWM4_EPWMB_GPIO 5
#define myEPWM4_EPWMB_PIN_CONFIG GPIO_7_EPWM4_B

//
// EPWM5 -> myEPWM4 Pinmux
//
//
// EPWM5_A - GPIO Settings
//
#define GPIO_PIN_EPWM5_A 8
#define myEPWM5_EPWMA_GPIO 8
#define myEPWM5_EPWMA_PIN_CONFIG GPIO_8_EPWM5_A
//
// EPWM5_B - GPIO Settings
//
#define GPIO_PIN_EPWM5_B 9
#define myEPWM5_EPWMB_GPIO 9
#define myEPWM5_EPWMB_PIN_CONFIG GPIO_9_EPWM5_B

//
// EPWM6 -> myEPWM6 Pinmux
//
//
// EPWM6_A - GPIO Settings
//
#define GPIO_PIN_EPWM6_A 10
#define myEPWM6_EPWMA_GPIO 10
#define myEPWM6_EPWMA_PIN_CONFIG GPIO_10_EPWM6_A
//
// EPWM6_B - GPIO Settings
//
#define GPIO_PIN_EPWM6_B 11
#define myEPWM6_EPWMB_GPIO 11
#define myEPWM6_EPWMB_PIN_CONFIG GPIO_11_EPWM6_B

//
// EPWM7 -> myEPWM7 Pinmux
//
//
// EPWM7_A - GPIO Settings
//
#define GPIO_PIN_EPWM7_A 12
#define myEPWM7_EPWMA_GPIO 12
#define myEPWM7_EPWMA_PIN_CONFIG GPIO_12_EPWM7_A
//
// EPWM7_B - GPIO Settings
//
#define GPIO_PIN_EPWM7_B 29 // gpio13 not support
#define myEPWM7_EPWMB_GPIO 29 // gpio13 not support
#define myEPWM7_EPWMB_PIN_CONFIG GPIO_29_EPWM7_B //GPIO_13_EPWM7_B

//
// EPWM8 -> myEPWM8 Pinmux
//
//
// EPWM8_A - GPIO Settings
//
#define GPIO_PIN_EPWM8_A 14
#define myEPWM8_EPWMA_GPIO 14
#define myEPWM8_EPWMA_PIN_CONFIG GPIO_14_EPWM8_A
//
// EPWM8_B - GPIO Settings
//
#define GPIO_PIN_EPWM8_B 15
#define myEPWM8_EPWMB_GPIO 15
#define myEPWM8_EPWMB_PIN_CONFIG GPIO_15_EPWM8_B

//
// EPWM9 -> myEPWM9 Pinmux
//
//
// EPWM9_A - GPIO Settings
//
#define GPIO_PIN_EPWM9_A 16
#define myEPWM9_EPWMA_GPIO 16
#define myEPWM9_EPWMA_PIN_CONFIG GPIO_16_EPWM9_A
//
// EPWM8_B - GPIO Settings
//
#define GPIO_PIN_EPWM9_B 51  //gpio43 not support
#define myEPWM9_EPWMB_GPIO 51  //gpio43 not suport
#define myEPWM9_EPWMB_PIN_CONFIG GPIO_51_EPWM9_B //GPIO_43_EPWM9_B

//
// EPWM10 -> myEPWM10 Pinmux
//
//
// EPWM10_A - GPIO Settings
//
#define GPIO_PIN_EPWM10_A 24
#define myEPWM10_EPWMA_GPIO 24
#define myEPWM10_EPWMA_PIN_CONFIG GPIO_24_EPWM10_A
//
// EPWM10_B - GPIO Settings
//
#define GPIO_PIN_EPWM10_B 26
#define myEPWM10_EPWMB_GPIO 26
#define myEPWM10_EPWMB_PIN_CONFIG GPIO_26_EPWM10_B

//
// EPWM11 -> myEPWM11 Pinmux
//
//
// EPWM11_A - GPIO Settings
//
#define GPIO_PIN_EPWM11_A 22
#define myEPWM11_EPWMA_GPIO 22
#define myEPWM11_EPWMA_PIN_CONFIG GPIO_22_EPWM11_A
//
// EPWM11_B - GPIO Settings
//
#define GPIO_PIN_EPWM11_B 23
#define myEPWM11_EPWMB_GPIO 23
#define myEPWM11_EPWMB_PIN_CONFIG GPIO_23_EPWM11_B

//
// EPWM12 -> myEPWM12 Pinmux
//
//
// EPWM12_A - GPIO Settings
//
#define GPIO_PIN_EPWM12_A 28
#define myEPWM12_EPWMA_GPIO 28
#define myEPWM12_EPWMA_PIN_CONFIG GPIO_28_EPWM12_A
//
// EPWM12_B - GPIO Settings
//
#define GPIO_PIN_EPWM12_B 29
#define myEPWM12_EPWMB_GPIO 29
#define myEPWM12_EPWMB_PIN_CONFIG GPIO_29_EPWM12_B

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
#define Test_EPWM  EPWM1_BASE
#define DMAMUX_ReqId_PWMA  DMAMUX_ReqId_Trig_EPWM1xSOCA
#define DMAMUX_ReqId_PWMB  DMAMUX_ReqId_Trig_EPWM1xSOCB

#define Test_EPWMA_PIN_CONFIG  	myEPWM1_EPWMA_PIN_CONFIG
#define Test_EPWMA_GPIO       	myEPWM1_EPWMA_GPIO
#define Test_EPWMB_PIN_CONFIG  	myEPWM1_EPWMB_PIN_CONFIG
#define Test_EPWMB_GPIO       	myEPWM1_EPWMB_GPIO

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */
//*****************************************************************************
//
// GPIO Configurations
//
//*****************************************************************************
#define myGPIO25 25
void myGPIO25_init();

//*****************************************************************************
//
// INPUTXBAR Configurations
//
//*****************************************************************************
#define myINPUTXBARINPUT0_SOURCE 2
#define myINPUTXBARINPUT0_INPUT XBAR_INPUT5
void myINPUTXBARINPUT0_init();
#define myINPUTXBARINPUT1_SOURCE 1
#define myINPUTXBARINPUT1_INPUT XBAR_INPUT6
void myINPUTXBARINPUT1_init();
//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void	Board_init();
void	EPWM_init();
void	SYNC_init();
void	PinMux_init();
void uart_dma_tx();
void PREPWM_init();
/**
 * \brief   "add brief description of this function" 
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */


#ifdef __cplusplus
}
#endif


#endif /* DMA_EX03_EPWM_PUTY_CHANGE_BOARD_H_ */
