/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    dma_ex05_CRC_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

//#include "GS32F00xx.h"
#include "dma_ex05_CRC_board.h"
#include "stdio.h"
#include "crc.h"
#include "interrupt.h"
#include "printf.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


#define DMA_BUF_SIZE 4
#define CRC_DR				CRC_BASE + 0x00

#if (GS32F00xx == 0x1100 || GS32F00xx == 0x0011)
#define CRC_IRQn    INT_CRC_DONE
#define CRC_INTCLR(b)            CRC_clearIntRawFlagDone(b)
#else
#define CRC_IRQn    INT_CRC
#define CRC_INTCLR(b)            CRC_clearIntRawFlagDone(b)
#endif

uint32_t CRC_data_in[DMA_BUF_SIZE] = {0x00000011,0x00000022,0x00000033,0x00000044};
uint32_t CRC_data_in_7bit = 0x0000007f;
uint32_t CRC_result[5] = {0,0,0,0,0};
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */



/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
void INTERRUPTCRC_init();
void delay_us(uint32_t delay_us);
 /**
 * \brief   Test CPUCRC
 * \param   none
 * \retval  None
 */
uint16_t i=0;
 void Test_dmaCRC(void)
{
	
	INTERRUPTCRC_init();
	
	/* Config DMA to trans CRC result to memory */
	DMA_ConfigParams dmaCfg = {0};
    
    DMA_initController(DMA_BASE);
	
#if 1
	/* Stop DMA channel first - why the DMA channel is still pending after reset? */
	DMA_stopChannel(DMA_CH1_BASE);
	
	/* DMA Config */
	dmaCfg.enableInterrupt = 0;
//	dmaCfg.dmaMuxCCR = 0;
//	dmaCfg.dmaMuxRGCR = 0;
	dmaCfg.srcAddr = (uint32_t)CRC_data_in;
	dmaCfg.destAddr = CRC_DR;
	dmaCfg.blockTS = DMA_BUF_SIZE;
	dmaCfg.ttfc    = DMA_TT_FC_0_M2M_DMAC;
	dmaCfg.srcBtl  = DMA_BTL_4;
	dmaCfg.destBtl = DMA_BTL_4;
	dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
	dmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
	dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
	dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_4;
	DMA_configChannel(DMA_CH1_BASE, &dmaCfg);


		
	delay_us(1000);
	

	
	/* Set CRC32bit to calculate */
	CRC_setDataLength(CRC_BASE,4);
	CRC_writeGoldenValue(CRC_BASE,0xF2074901);
	CRC_startCalculation(CRC_BASE);
	DMA_startChannel(DMA_CH1_BASE);//
	
	/* Check if the result is right */
	CRC_result[0] = CRC_getResult(CRC_BASE);
	
	if(CRC_result[0] == 0xF2074901)/*32poly 04C11DB7*/
		printf("DMA32bitCRC test success\r\n");
	else
		printf("DMA32bitCRC test failed\r\n");

/*******************************************************************/

		/* DMA Config */
	dmaCfg.enableInterrupt = 0;
//	dmaCfg.dmaMuxCCR = 0;
//	dmaCfg.dmaMuxRGCR = 0;
	dmaCfg.srcAddr = (uint32_t)CRC_data_in;
	dmaCfg.destAddr = CRC_DR;
	dmaCfg.blockTS = DMA_BUF_SIZE;
	dmaCfg.ttfc    = DMA_TT_FC_0_M2M_DMAC;
	dmaCfg.srcBtl  = DMA_BTL_4;
	dmaCfg.destBtl = DMA_BTL_4;
	dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
	dmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
	dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
	dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_4;
	DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

	delay_us(1000);

	/* INIT  */
	CRC_setInitValue(CRC_BASE,0x00000000);
	/* RESET */
	CRC_resetCalculation(CRC_BASE);
	/* Set CRC16bit  Polynomial size */
	CRC_setPolysize(CRC_BASE,CRC_POLYSIZE_24BIT);
	CRC_setPoly(CRC_BASE,0x00864CFB);
	CRC_setDataLength(CRC_BASE,4);
	CRC_writeGoldenValue(CRC_BASE,0x00C86C58);
	CRC_startCalculation(CRC_BASE);
	DMA_startChannel(DMA_CH1_BASE);//

	/* Check if the result is right */
	CRC_result[1] = CRC_getResult(CRC_BASE);
	
	if(CRC_result[1] == 0xC86C58) /*24poly 864CFB*/
		printf("DMA24bitCRC test success\r\n");
	else
		printf("DMA24bitCRC test failed\r\n");
/*******************************************************************/


		/* DMA Config */
	dmaCfg.enableInterrupt = 0;
//	dmaCfg.dmaMuxCCR = 0;
//	dmaCfg.dmaMuxRGCR = 0;
	dmaCfg.srcAddr = (uint32_t)CRC_data_in;
	dmaCfg.destAddr = CRC_DR;
	dmaCfg.blockTS = DMA_BUF_SIZE;
	dmaCfg.ttfc    = DMA_TT_FC_0_M2M_DMAC;
	dmaCfg.srcBtl  = DMA_BTL_4;
	dmaCfg.destBtl = DMA_BTL_4;
	dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
	dmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
	dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
	dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_4;
	DMA_configChannel(DMA_CH1_BASE, &dmaCfg);
	
	delay_us(1000);

	/* INIT  */
	CRC_setInitValue(CRC_BASE,0x00000000);
	/* RESET */
	CRC_resetCalculation(CRC_BASE);
	/* Set CRC16bit  Polynomial size */
	CRC_setPolysize(CRC_BASE,CRC_POLYSIZE_16BIT);
	CRC_setPoly(CRC_BASE,0x00008005);
	CRC_setDataLength(CRC_BASE,4);
	CRC_writeGoldenValue(CRC_BASE,0x00001D84);
	CRC_startCalculation(CRC_BASE);
	DMA_startChannel(DMA_CH1_BASE);//
	
	/* Check if the result is right */
	CRC_result[2] = CRC_getResult(CRC_BASE);
	
	if(CRC_result[2] == 0x1D84) /*16poly 8005*/
		printf("DMA16bitCRC test success\r\n");
	else
		printf("DMA16bitCRC test failed\r\n");
/*******************************************************************/

		/* DMA Config */
	dmaCfg.enableInterrupt = 0;
//	dmaCfg.dmaMuxCCR = 0;
//	dmaCfg.dmaMuxRGCR = 0;
	dmaCfg.srcAddr = (uint32_t)CRC_data_in;
	dmaCfg.destAddr = CRC_DR;
	dmaCfg.blockTS = DMA_BUF_SIZE;
	dmaCfg.ttfc    = DMA_TT_FC_0_M2M_DMAC;
	dmaCfg.srcBtl  = DMA_BTL_4;
	dmaCfg.destBtl = DMA_BTL_4;
	dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
	dmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
	dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
	dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_4;
	DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

	/* INIT  */
	CRC_setInitValue(CRC_BASE,0x00000000);
	/* RESET */
	CRC_resetCalculation(CRC_BASE);
	/* Set CRC8bit  Polynomial size */
	CRC_setPolysize(CRC_BASE,CRC_POLYSIZE_8BIT);
	CRC_setPoly(CRC_BASE,0x00000007);
	CRC_setDataLength(CRC_BASE,4);
	CRC_writeGoldenValue(CRC_BASE,0x000000F9);
	CRC_startCalculation(CRC_BASE);
	DMA_startChannel(DMA_CH1_BASE);//
	
	delay_us(1000);

	/* Check if the result is right */
	CRC_result[3] = CRC_getResult(CRC_BASE);
	if(CRC_result[3] == 0xF9) /*8poly 07*/
		printf("DMA8bitCRC test success\r\n");
	else
		printf("DMA8bitCRC test failed\r\n");
		#endif
/*******************************************************************/

    DMA_initController(DMA_BASE);

		/* DMA Config */
	dmaCfg.enableInterrupt = 0;
//	dmaCfg.dmaMuxCCR = 0;
//	dmaCfg.dmaMuxRGCR = 0;
	dmaCfg.srcAddr = (uint32_t)CRC_data_in_7bit;
	dmaCfg.destAddr = CRC_DR;
	dmaCfg.blockTS = 1;
	dmaCfg.ttfc    = DMA_TT_FC_0_M2M_DMAC;
	dmaCfg.srcBtl  = DMA_BTL_4;
	dmaCfg.destBtl = DMA_BTL_4;
	dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
	dmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
	dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
	dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_4;
	DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

	/* INIT  */
	CRC_setInitValue(CRC_BASE,0x00000000);
	/* RESET */
	CRC_resetCalculation(CRC_BASE);
	/* Set CRC8bit  Polynomial size */
	CRC_setPolysize(CRC_BASE,CRC_POLYSIZE_7BIT);
	CRC_setPoly(CRC_BASE,0x00000009);
	CRC_setDataLength(CRC_BASE,1);
	CRC_writeGoldenValue(CRC_BASE,0x00000038);
	CRC_startCalculation(CRC_BASE);
	DMA_startChannel(DMA_CH1_BASE);//

	delay_us(1000);

	/* Check if the result is right */
	CRC_result[4] = CRC_getResult(CRC_BASE);
	if(CRC_result[4] == 0x38) /*7poly 09*/
		printf("DMA7bitCRC test success\r\n");
	else
		printf("DMA7bitCRC test failed\r\n");
/*******************************************************************/
	

}


void CRC_DONE_INT_IRQHandler()
{
	//go to CRC calculation interrupt

	if(CRC_getIntFlagDone(CRC_BASE) == 1)
	{
		if(CRC_getResult(CRC_BASE) == 0xF2074901)
		printf("DMA32bitCRC interrupt test successs\r\n");
		else if(CRC_getResult(CRC_BASE) == 0xC86C58)
		printf("Cpu24bitCRC interrupt test successs\r\n");
		else if(CRC_getResult(CRC_BASE) == 0x1D84)
		printf("DMA16bitCRC interrupt test successs\r\n");
		else if(CRC_getResult(CRC_BASE) == 0xF9)
		printf("DMA8bitCRC interrupt test successs\r\n");
		else if(CRC_getResult(CRC_BASE) == 0x38)
		printf("Cpu7bitCRC interrupt test successs\r\n");
		else
		printf("DMACRC interrupt test error\r\n");
		CRC_INTCLR(CRC_BASE);
	}
}
void delay_us(uint32_t delay_us)
{
  volatile unsigned int num;
  volatile unsigned int t;


  for (num = 0; num < delay_us; num++)
  {
    t = 11;
    while (t != 0)
    {
      t--;
    }
  }
}


// INTERRUPT Configurations
void INTERRUPTCRC_init()
{
    Interrupt_SetPriority(CRC_IRQn, 0, 0);
    Interrupt_register(CRC_IRQn, CRC_DONE_INT_IRQHandler);
    Interrupt_enable(CRC_IRQn);
}

//void DMA_INT_CH0_ISTATUSTFR_IRQHandler()
//{	
//	DMA_clearInterrupt(DMA_CH0_BASE, DMA_INT_TFR);
//	printf("DMA interrupt.\n");

//}

#ifdef __cplusplus
}
#endif

