/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    dma_ex11_sci_autoback_with_timeout_burst.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "board_cfg.h"
#include "load_img.h"
#include <sys/stat.h>
#include "log.h"
#include "dma_ex11_sci_autoback_with_timeout_burst_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

void Config_scib_full_duplex_with_timeout(void);
/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */



/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/**
 * \brief   add brief
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */
void Config_scib_full_duplex_with_timeout(void)
{

    uint16_t resultsIndex;

    // 
    // Board Initializatrion
    // 
    Board_init();

    Interrupt_register(DMA_INT_CH4_IRQn, &DMA_CH4_IRQHandler);
    Interrupt_register(DMA_INT_CH5_IRQn, &DMA_CH5_IRQHandler);
    Interrupt_register(INT_TIMER0, &sTimeBaseIsr);

    //
    // Enable interrupts required for this example
    //
    Interrupt_enable(DMA_INT_CH4_IRQn);
    Interrupt_enable(DMA_INT_CH5_IRQn);
    Interrupt_enable(INT_TIMER0);

    //
    // Initialize the DMA & configure DMA channels 0
    //
    DMA_initController(DMA_BASE);

     //
     // Init SCIB module
     //
    Uart_Init();
    
    //
    // Config DMA channel 0
    //
    DMA_CHN_Modeconfig();


    
    //
    // Init cpuTImer0 1ms for sTimeBaseIsr ervice.
    //
    InitCpuTimer(CPUTIMER0_BASE, DEVICE_APBCLK_FREQ/1000);

    //
    // Start timer0
    //
    CPUTimer_startTimer(CPUTIMER0_BASE);

    //
    // Start Channel6 for SCI-RX DMA
    //
    DMA_startChannel(DMA_CH5_BASE);
}

  
int main(void)
{
    int ret;

#if ((GS32F3xx & 0xFF00) || (GS32F00xx & 0xFF00))
    Device_init();
#endif

    //
    // Disable global interrupts.
    //
    __disable_irq();

    //bringup_dsp();

    Config_scib_full_duplex_with_timeout();
    

    //
    // Enable global interrupts
    //
    __enable_irq();

    /* We should never get here as control is now taken by the scheduler */
    for(;;);
}

#ifdef __cplusplus
}
#endif

