/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    ecap_ex01_apwm.c
*   @brief
*   @details
*
*/

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"
#include "ecap_ex01_board.h"


/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define EDA_CSIM    0             //set to 1 when make target for simulation

#if EDA_CSIM != 0
#define LOG_LEVEL                 LOG_ERROR
void _putchar(char character)
{
    //do nothing
}
#else
#define LOG_LEVEL                 LOG_INFO
#endif
#define PWM_CLK   5UL       // PWM frequency as 5Hz
#define Period_VAL  (20000000U / PWM_CLK)    // Calculate period value
#define DECREASE_FREQUENCY  0
#define INCREASE_FREQUENCY  1

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

uint16_t direction;
vuint32_t cap1Count;
volatile uint32_t dspTicks = 0;

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */




int main(void)
{
	Device_init();
	__enable_irq();
	// Board initialization
    // Select eCAP1OUT on MUX 0. Make GPIO5 as eCAP1OUT for PWM output
    // Select eCAP2OUT on MUX 2. Make GPIO6 as eCAP2OUT for PWM output
    // Configure eCAP1 in APWM mode with defined period and duty values
    // Polarity as low and configure SYNCOUT at CTR=PRD
    //
	Board_init();


	for(;;)
	{
		// Set the duty cycle to 50%
		ECAP_setAPWMShadowCompare(myECAP0_BASE,
						(ECAP_getEventTimeStamp(myECAP0_BASE, ECAP_EVENT_1) >> 1U));
		cap1Count = ECAP_getEventTimeStamp(myECAP0_BASE,ECAP_EVENT_1);

		// Vary frequency
		if (cap1Count >= Period_VAL)
		{
			direction = INCREASE_FREQUENCY;
		}
		else if (cap1Count <= Period_VAL/2)
		{
			direction = DECREASE_FREQUENCY;
		}
		if (direction == INCREASE_FREQUENCY)
		{
			ECAP_setAPWMShadowPeriod(myECAP0_BASE,(cap1Count - 500000U));
		}
		else
		{
			ECAP_setAPWMShadowPeriod(myECAP0_BASE,(cap1Count + 500000U));
		}
    }

    return 0;
}

