/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    ecap_ex01_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "ecap_ex01_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

// Board Configurations
void Board_init(void)
{
    PinMux_init();

	OUTPUTXBAR_init();

	ECAP_init();
}

// PinMux Configurations
void PinMux_init(void)
{
    // PinMux for modules assigned to CPU

	GPIO_setPinConfig(GPIO_24_OUTPUTXBAR1 );
	GPIO_setPinConfig(GPIO_25_OUTPUTXBAR2);
	GPIO_setPinConfig(GPIO_26_OUTPUTXBAR3);
	GPIO_setPinConfig(GPIO_27_OUTPUTXBAR4);


}

// ECAP Configurations
void ECAP_init(){
    myECAP0_init();
}

// ECAP Configurations for ECAP1
void myECAP0_init(){
    // Stops Time stamp counter.
	
	ECAP_stopCounter(myECAP0_BASE);
	ECAP_stopCounter(ECAP2_BASE);
	ECAP_stopCounter(ECAP3_BASE);


	// Sets eCAP in APWM mode.
	
	ECAP_enableAPWMMode(myECAP0_BASE);
	ECAP_enableAPWMMode(ECAP2_BASE);
	ECAP_enableAPWMMode(ECAP3_BASE);

	
	// Set eCAP APWM period.
	//ECAP_setAPWMPeriod(myECAP0_BASE,4000000U);
	ECAP_setAPWMPeriod(myECAP0_BASE,4000000U);
	ECAP_setAPWMPeriod(ECAP2_BASE,4000000U);
	ECAP_setAPWMPeriod(ECAP3_BASE,4000000U);

	
	// Set eCAP APWM on or off time count.
	
	ECAP_setAPWMCompare(myECAP0_BASE,2000000U);
	ECAP_setAPWMCompare(ECAP2_BASE,2000000U);
	ECAP_setAPWMCompare(ECAP3_BASE,2000000U);


	// Set eCAP APWM polarity.
	
	ECAP_setAPWMPolarity(myECAP0_BASE,ECAP_APWM_ACTIVE_HIGH);
	ECAP_setAPWMPolarity(ECAP2_BASE,ECAP_APWM_ACTIVE_HIGH);
	ECAP_setAPWMPolarity(ECAP3_BASE,ECAP_APWM_ACTIVE_HIGH);

	
	// Sets a phase shift value count.
	
	ECAP_setPhaseShiftCount(myECAP0_BASE,0U);
	ECAP_setPhaseShiftCount(ECAP2_BASE,0U);
	ECAP_setPhaseShiftCount(ECAP3_BASE,0U);

	
	// Disable counter loading with phase shift value.
	
	ECAP_disableLoadCounter(myECAP0_BASE);
	ECAP_disableLoadCounter(ECAP2_BASE);
	ECAP_disableLoadCounter(ECAP3_BASE);

	

	// Configures Sync out signal mode.
	
	ECAP_setSyncOutMode(myECAP0_BASE,ECAP_SYNC_OUT_SYNCI);
	ECAP_setSyncOutMode(ECAP2_BASE,ECAP_SYNC_OUT_SYNCI);
	ECAP_setSyncOutMode(ECAP3_BASE,ECAP_SYNC_OUT_SYNCI);

	
	// Configures emulation mode.
	
	ECAP_setEmulationMode(myECAP0_BASE,ECAP_EMULATION_STOP);
	ECAP_setEmulationMode(ECAP2_BASE,ECAP_EMULATION_STOP);
	ECAP_setEmulationMode(ECAP3_BASE,ECAP_EMULATION_STOP);

	

	// Set up the source for sync-in pulse..
	
//	SysCtl_setECAPSyncInPulseSource(myECAP0_SYNC_IN_OFFSET,ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1);
	
	// Starts Time stamp counter for myECAP0.
	
	ECAP_startCounter(myECAP0_BASE);
	ECAP_startCounter(ECAP2_BASE);
	ECAP_startCounter(ECAP3_BASE);

}

// OUTPUTXBAR Configurations
void OUTPUTXBAR_init(){
    myOUTPUTXBAR0_init();
}

// OUTPUTXBAR Configurations for ECAP1
void myOUTPUTXBAR0_init(){
	//
	//Mux configuration
	//
	XBAR_enableOutputMux(myOUTPUTXBAR0_BASE,XBAR_OUTPUT1, XBAR_MUX00);
	XBAR_enableOutputMux(myOUTPUTXBAR0_BASE,XBAR_OUTPUT2, XBAR_MUX02);
	XBAR_enableOutputMux(myOUTPUTXBAR0_BASE,XBAR_OUTPUT3, XBAR_MUX04);


	XBAR_setOutputMuxConfig(myOUTPUTXBAR0_BASE,XBAR_OUTPUT1, XBAR_OUT_MUX00_ECAP1_OUT);
	XBAR_setOutputMuxConfig(myOUTPUTXBAR0_BASE,XBAR_OUTPUT2, XBAR_OUT_MUX02_ECAP2_OUT);
	XBAR_setOutputMuxConfig(myOUTPUTXBAR0_BASE,XBAR_OUTPUT3, XBAR_OUT_MUX04_ECAP3_OUT);



	XBAR_invertOutputSignal(myOUTPUTXBAR0_BASE,XBAR_OUTPUT1, false);
	XBAR_invertOutputSignal(myOUTPUTXBAR0_BASE,XBAR_OUTPUT2, false);
	XBAR_invertOutputSignal(myOUTPUTXBAR0_BASE,XBAR_OUTPUT3, false);


	XBAR_setOutputLatchMode(myOUTPUTXBAR0_BASE,XBAR_OUTPUT1, false);
	XBAR_setOutputLatchMode(myOUTPUTXBAR0_BASE,XBAR_OUTPUT2, false);
	XBAR_setOutputLatchMode(myOUTPUTXBAR0_BASE,XBAR_OUTPUT3, false);


}

/**
 * \brief   "add brief description of this function" 
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif
