/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hrcap_ex01_board.c
*   @brief
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "hrcap_ex01_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

// Board Configurations
void Board_init()
{
	INPUTXBAR_init();
    ECAP_init();
    GPIO_init();
    INTERRUPT_init();
}

// GPIO Configurations
void GPIO_init()
{
	myGPIO0_init();
}

// GPIO Configurations for GPIO
void myGPIO0_init()
{
	GPIO_setPinConfig(myGPIO0_PIN_CONFIG);
	GPIO_setPadConfig(0, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(0, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_8_GPIO8);
	GPIO_setPadConfig(8, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(8, GPIO_QUAL_SYNC);



	GPIO_setPinConfig(GPIO_24_OUTPUTXBAR1);
	GPIO_setPadConfig(24, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(24, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_25_OUTPUTXBAR2);
	GPIO_setPadConfig(25, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(25, GPIO_QUAL_SYNC);
}

// ECAP Configurations
void ECAP_init()
{
    myECAP0_init();
}

// ECAP1~6
void myECAP0_init()
{
	//
	// HRCAP module configuration for myECAP0_HR_BASE (part of myECAP0_BASE).
	//
	// Enable High resolution clock
	//
	HRCAP_enableHighResolutionClock(myECAP0_HR_BASE);
	DEVICE_DELAY_US(1); // 1us delay as mentioned in HRCAP chapter of TRM
	//
	// Enable High Resolution module
	//
	HRCAP_enableHighResolution(myECAP0_HR_BASE);
	DEVICE_DELAY_US(1); // 1us delay as mentioned in HRCAP chapter of TRM
	//
	// Disable ,clear all capture flags and interrupts
	//
	ECAP_disableInterrupt(myECAP0_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
	ECAP_clearInterrupt(myECAP0_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
	//
	// Disables time stamp capture.
	//
	ECAP_disableTimeStampCapture(myECAP0_BASE);
	//
	// Stops Time stamp counter.
	//
	ECAP_stopCounter(myECAP0_BASE);
	//
	// Sets eCAP in Capture mode.
	//
	ECAP_enableCaptureMode(myECAP0_BASE);
	//
	// Sets the capture mode.
	//
	ECAP_setCaptureMode(myECAP0_BASE,ECAP_ONE_SHOT_CAPTURE_MODE,ECAP_EVENT_4);
	//
	// Sets the Capture event prescaler.
	//
	ECAP_setEventPrescaler(myECAP0_BASE, 0U);
	//
	// Sets the Capture event polarity.
	//
	ECAP_setEventPolarity(myECAP0_BASE,ECAP_EVENT_1,ECAP_EVNT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP0_BASE,ECAP_EVENT_2,ECAP_EVNT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP0_BASE,ECAP_EVENT_3,ECAP_EVNT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP0_BASE,ECAP_EVENT_4,ECAP_EVNT_FALLING_EDGE);
	//
	// Configure counter reset on events
	//
	ECAP_disableCounterResetOnEvent(myECAP0_BASE,ECAP_EVENT_1);
	ECAP_disableCounterResetOnEvent(myECAP0_BASE,ECAP_EVENT_2);
	ECAP_disableCounterResetOnEvent(myECAP0_BASE,ECAP_EVENT_3);
	ECAP_disableCounterResetOnEvent(myECAP0_BASE,ECAP_EVENT_4);
	//
	// Select eCAP input.
	//
	ECAP_selectECAPInput(myECAP0_BASE,ECAP_INPUT_GPIO8 );
	//
	// Sets a phase shift value count.
	//
	ECAP_setPhaseShiftCount(myECAP0_BASE,0U);
	//
	// Enable counter loading with phase shift value.
	//
	ECAP_enableLoadCounter(myECAP0_BASE);
	//
	// Configures Sync out signal mode.
	//
	ECAP_setSyncOutMode(myECAP0_BASE,ECAP_SYNC_OUT_SYNCI);
	//
	// Resets eCAP counters and flags.
	//
	ECAP_resetCounters(myECAP0_BASE);

	//
	// Configures emulation mode.
	//
	ECAP_setEmulationMode(myECAP0_BASE,ECAP_EMULATION_STOP);
	//
	// Set up the source for sync-in pulse..
	//
	ECAP_setSyncInPulseSource(myECAP0_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1);
	//
	// Starts Time stamp counter for myECAP0.
	//
	ECAP_startCounter(myECAP0_BASE);
	//
	// Enables time stamp capture for myECAP0.
	//
	ECAP_enableTimeStampCapture(myECAP0_BASE);
	//
	// Re-arms the eCAP module for myECAP0.
	//
	ECAP_reArm(myECAP0_BASE);
	//
	// Enables interrupt source for myECAP0.
	//
	ECAP_enableInterrupt(myECAP0_BASE,(ECAP_ISR_SOURCE_CAPTURE_EVENT_4));
	//
	// myECAP0_HR_BASE Calibration Settings
	//
	// Set calibration period (register is in SYSCLK cycles), 1.6ms recommended
	//
	HWREG(myECAP0_HR_BASE + HRCAP_O_HRCALPRD) = (uint32_t) (120e9 * (1.6/1000));
	//
	// Configure in continuous calibration mode
	//
	HRCAP_setCalibrationMode(myECAP0_HR_BASE);
	//
	// Enable HRCAP calibration interrupts
	//
	HRCAP_enableCalibrationInterrupt(myECAP0_HR_BASE, (HRCAP_CALIBRATION_DONE
		 | HRCAP_CALIBRATION_PERIOD_OVERFLOW));
	//
	// Start HR calibration
	//
	HRCAP_startCalibration(myECAP0_HR_BASE);
}

// INPUTXBAR Configurations
void INPUTXBAR_init()
{
	myINPUTXBARINPUT0_init();
}

// OUTPUTXBAR Configurations for ECAP1 output
void myINPUTXBARINPUT0_init()
{
	XBAR_setInputPin(INPUTXBAR_BASE,myINPUTXBARINPUT0_INPUT, myINPUTXBARINPUT0_SOURCE);
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE ,XBAR_OUTPUT2,XBAR_OUT_MUX17_INPUTXBAR7);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE ,XBAR_OUTPUT2,XBAR_MUX17);
}

void INTERRUPT_init()
{
	Interrupt_SetPriorityGrouping(0);
	Interrupt_SetPriority(myECAP0_BASE,0,0);
	Interrupt_SetPriority(myECAP0_HR_BASE,0,0);
	Interrupt_register(INT_myECAP0,Hrcap_ex01_IrqHandler1);
	Interrupt_register(INT_ECAP3,Hrcap_ex01_IrqHandler2);
	Interrupt_enable(INT_myECAP0);
	Interrupt_enable(INT_ECAP3);
	EINT; // __enable_irq();
}

/**
 * \brief   "add brief description of this function"
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

