/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hrcap_ex01_board.h
*   @brief
*
*/

#ifndef HRCAP_EX01_BOARD_H_
#define HRCAP_EX01_BOARD_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "driverlib.h"
#include "device.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define myGPIO0_PIN_CONFIG	GPIO_0_EPWM1_A

#define myECAP0_BASE	ECAP6_BASE
#define myECAP0_HR_BASE	ECAP6_BASE

#define myINPUTXBARINPUT0_SOURCE 8

#define myINPUTXBARINPUT0_INPUT XBAR_INPUT7
#define INT_myECAP0	INT_ECAP6
#define INT_myECAP0_HR	INT_ECAP6_2

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */


void myECAP0_init(void);
void myGPIO0_init(void);
void myINPUTXBARINPUT0_init(void);

void Board_init(void);
void ECAP_init(void);
void GPIO_init(void);
void INPUTXBAR_init(void);
void INTERRUPT_init(void);

extern void Hrcap_ex01_IrqHandler1(void);
extern void Hrcap_ex01_IrqHandler2(void);

/**
 * \brief   "add brief description of this function"
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif


#endif /* HRCAP_EX08_BOARD_H_ */
