
#ifndef __TASK_H__
#define __TASK_H__

#include <stdint.h>

#define kernel_t    uint32_t
#define taskEvent_t uint16_t
#define knlStack_t  kernel_t

#define bool_t      uint32_t

#define true        1
#define false       0
#define inval       2

#define TaskStackSize   512    //4bytes, words
//******************************************************************************
//*                 the constant definition
//******************************************************************************
//define the Task priority
enum
{
    cPrioSuper = 0,
    cPriManage,
    cPrioSciComm,
    cPrioDataTask,
    cPrioIdle,
    cPrioRsvd
};

// super task event
enum
{
    eSuperTimer = 0,
    eSuperTurnOn,
    eSuperFault,
    eSuperTurnOff,
    eSuperCurrAutoZero,
    eSuperPvIsoCheck,
    eSuperToOffGridMode,
    eSuperToGridMode,
    eSuperRestart,
    eSuperToVoltVerifyMode,
    eSuperGfciCheck,
    eSuperToPVOffGridMode
};

enum
{
    eDispTimer = 0,
    eKeyDown,
    eKeyUp,
    eKeyEnter,
    eKeyEsc,
    eToSts
};

//manage task event
enum
{
    eManageTimer = 0,
    eManageGridZero,
    eManageSinZero,
    eManageZeroFlow,
    eManage10MinVoltAvg,
    eManageSineFall,
    eMagage10msGridCheck
};

enum
{
    eDCTimer=0
};

// comm task event
enum
{
    eSciCommTimer = 0,
    eHandleSciaRxData,
    eHandleScibRxData,
    eHandleLinaData,
    eHandleLinbData,
    eHandleCanaRxData
};

// spi event
enum
{
    eLogTimer = 0,
    eLogSave,
    eLogRtc,
    eLogGet,
    eLogSN,
    eLogHardwareSave,
    eLogRtcSyc
};

enum
{
    eDataTimer = 0,
    eWrSampleParam,
    eWrLog,
    eWrSafetyPar,
    eWrModePar,
    eWrMachinePar,
    eWrDCSource,
    eWrHistoryEnegy,
    eWrIVCurve,
    eEraseFaultFlash,
    eWrFaultInfo,
    eRdFaultInfo,

    eInitManage,
    eWrFlashData,
    eWrFlashDataInfo
};


enum
{
   eSpiCommTimer = 0,
   eSpiCommSyc
};

//Para event
enum
{
    eParaTimer = 0,
    eParaParsing
};

#define timerTickHook  proCheckComm

//******************************************************************************
//*                 the  global variable  data type define
//******************************************************************************



//******************************************************************************
//*                 the  global variable declarations
//******************************************************************************


//******************************************************************************
//*                 the function declarations
//******************************************************************************

int sDispStack(uint8_t *p);

#endif
/*****************************end of the Task.h ****************************/
