/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"
#include "nmsis_gcc.h"
#include <rtthread.h>

#define LED_GPIO_PIN    GPIO_PIN_LED1
#define LED_GPIO_CFG    GPIO_CFG_LED1

volatile uint32_t dspTicks = 0;
volatile uint32_t testVariable = 0x12345678;
volatile uint32_t testVariable1 = 0;
rt_thread_t thread1;
rt_thread_t thread2;

void TIMER1_IRQHandler(void)
{
	CPUTimer_clearOverflowFlag(CPUTIMER1_BASE);
	dspTicks += 1;
}

int32_t Timer1_init(uint32_t period)
{
	/* Initialize CPUTimer with interrupt enable */
	CPUTimer_init(CPUTIMER1_BASE, period);

	Interrupt_register(INT_TIMER1, TIMER1_IRQHandler);
	Interrupt_enable(INT_TIMER1);

	return 0;
}


void thread1_entry(void *parameter)
{
    int cnt = 0;
    printf("Enter to thread1\r\n");
    while (1) {
        printf("thread1 is running %d.....\r\n", cnt++);
        rt_thread_mdelay(500);
    }
}

void thread2_entry(void *parameter)
{
    int cnt = 0;
    printf("Enter to thread2\r\n");
    while (1) {
        printf("thread2 is running %d.....\r\n", cnt++);
        rt_thread_mdelay(500);
    }
}
int main(void)
{



    GPIO_setPinConfig(LED_GPIO_CFG);     //gpio
    GPIO_enableWritePin(LED_GPIO_PIN);
//    GPIO_togglePin(LED_GPIO_PIN);
    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    log_info("Hello DSP template!\r\n");
    log_info("Core running @ %d MHz.\r\n", DEVICE_SYSCLK_FREQ / 1000000);

    thread1 = rt_thread_create("thread1", thread1_entry, RT_NULL, 512, 4, 20);
    if(thread1 != RT_NULL)
    {
    	rt_thread_startup(thread1);
    }
    thread2 = rt_thread_create("thread2", thread2_entry, RT_NULL, 512, 4, 20);
    if(thread2 != RT_NULL)
    {
    	rt_thread_startup(thread2);
    }

//    testVariable1 = __RBIT(testVariable);


    while (1) {
//        if (dspTicks != oldTicks) {
//            oldTicks = dspTicks;
//            tickCnt += 1;
//
//            if ((tickCnt % 100) == 0) {
//                GPIO_togglePin(LED_GPIO_PIN);
//                log_info("ticks: %d\r\n", dspTicks);
//            }
//        }
    	GPIO_togglePin(LED_GPIO_PIN);
    	rt_thread_mdelay(500);
    }

    return 0;
}

