/*
 * sci_drv.h
 *
 *  Created on: 2025 Apr 21
 *      Author: s026h
 */

#ifndef INC_SCI_DRV_H_
#define INC_SCI_DRV_H_

#include "device.h"

typedef struct SCI_TxMsgCfg
{
	uint16_t TxIndex;
	uint16_t TxLen;
	uint16_t TxBuf[32];
}SCI_TxMsgCfg_t;

typedef struct SCI_RxMsgCfg
{
	uint16_t RxIndex;
	uint16_t RxLen;
	uint16_t RxBuf[32];
}SCI_RxMsgCfg_t;

extern SCI_TxMsgCfg_t SCI_TxMsg;
extern SCI_RxMsgCfg_t SCI_RxMsg;
extern uint8_t myRxBuf[32];

void sci_init(uint32_t sci_base);

void sci_cfg_init(SCI_TxMsgCfg_t *pSciTxMsg);

void sci_start_transmit(SCI_TxMsgCfg_t *pSciTxMsg, uint8_t *pSrcBuf, uint32_t len, uint32_t sci_base);

void sci_run_transmit(SCI_TxMsgCfg_t *pSciTxMsg, uint32_t sci_base);

void sci_start_receive(SCI_RxMsgCfg_t *pSciRxMsg, uint32_t len, uint32_t sci_base);

void sci_run_receive(SCI_RxMsgCfg_t *pSciRxMsg, uint8_t rxChar);

__INTERRUPT void SCIA_ISR(void);

__INTERRUPT void SCIB_ISR(void);


#endif /* INC_SCI_DRV_H_ */
