#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"
#include "xbar_test.h"

int main(void)
{
	/*Init*/
    Device_init();
    UartPrint_init(LOG_SCI_BASE, 115200);

    /* Configure GPIO0 for output mode */
	GPIO_setDirectionMode(0,GPIO_DIR_MODE_OUT);
	/*Configure GPIO1 as a normal GPIO*/
	GPIO_setPinConfig(GPIO_1_GPIO1);

    /*Setting the inputinv register to 0*/
    XBAR_invertInputSignal(XBAR_INPUT1, 0);


    GPIO_setPinConfig(GPIO_2_OUTPUTXBAR1);

    XBAR_setInputPin(INPUTXBAR_BASE,XBAR_OUTPUT1,1);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX01);
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_OUT_MUX01_INPUTXBAR1);

	while(1)
	{
		GPIO_writePin(0,1);
		DEVICE_DELAY_US(1000);
		GPIO_writePin(0,0);
		DEVICE_DELAY_US(1000);
	}




    return 0;
}

