//#############################################################################
//
// FILE:   clb_ex5_event_window.c
//
// TITLE:  CLB Auxilary PWM.
//
//!
//! This example uses the counter, FSM, and HLC sub-modules of the CLB to implement
//! an event timing feature which detects whether an interrupt service routine
//! takes too long to respond to an interrupt. The example configures four PWM
//! modules to operate in up-count mode and generate a low-to-high edge on a timer
//! zero match event. The zero match event also triggers a PWM ISR which, for the
//! purposes of this example, contains a dummy payload of variable length. At the
//! end of the ISR, a write operation takes place to a CLB GP register to indicate
//! the ISR has ended.
//!
#include "board_cfg.h"

#include "printf.h"
#include "board.h"

#define EDA_CSIM                  0             //set to 1 when make target for simulation

//--- interrupt service routines ---


int main(void)
{

    Device_init();

	__enable_irq();

	Board_init();


    CLB_setGPREG(myTILE1_BASE, 4);
    CLB_setGPREG(myTILE2_BASE, 4);

       while(1)
       {

       }


    return 0;
}




