/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    ecap_ex03_capture_pwm.h
*   @brief   
*
*/

#ifndef ECAP_EX04_SW_SYNC_H_
#define ECAP_EX04_SW_SYNC_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "driverlib.h"
#include "regs/regs_epwm.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
//
// Defines
//
#define myPREEPWM  PREEPWM_BASE

#define myEPWM1_BASE EPWM1_BASE

#define EPwm1Regs (*(volatile struct EPWM_REGS *) myEPWM1_BASE)

#define myEPWM2_BASE EPWM2_BASE

#define EPwm2Regs (*(volatile struct EPWM_REGS *) myEPWM2_BASE)

#define HRPWM_0CFG_VALUE 0x81F1CB83

#define HRPWM_1CFG_VALUE 0x703
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */




/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/**
 * \brief   "Executable function for ecap capturing pwm signals" 
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void ecap_ex03_capture_pwm(void);

/**
 * \brief   "add brief description of this function" 
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */


#ifdef __cplusplus
}
#endif


#endif /* ECAP_EX04_SW_SYNC_H_ */
