/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    ecap_ex05_capture_dma.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "board_cfg.h"
#include <ecap_ex05_board.h>
#include <ecap_ex05_capture_dma.h>
#include "printf.h"




/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

vuint16_t cap3Count;
vuint16_t cap4Count;
uint32_t ecapData[ECAP_COUNT*2] = {0};

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/**
 * \brief   // initEPWM - Configure ePWM
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void initEPWM()
{
    // Disable sync(Freeze clock to PWM as well)
    //
    // SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    // Configure ePWM
    //       Counter runs in up-count mode.
    //       Action qualifier will toggle output on period match
    //
    EPWM_setClockPrescaler(EPWM1_BASE,
                           EPWM_CLOCK_DIVIDER_1,
                           EPWM_HSCLOCK_DIVIDER_1);
	EPWM_setTimeBasePeriod(EPWM1_BASE, PWM_PRD_VAL);
	EPWM_setTimeBaseCounter(EPWM1_BASE,0U);
    EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP);
    EPWM_disablePhaseShiftLoad(EPWM1_BASE);
    EPWM_setPhaseShift(EPWM1_BASE, 0U);
	EPWM_setCounterCompareValue(EPWM1_BASE,EPWM_COUNTER_COMPARE_A,PWM_CMP_VAL);
	EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE,EPWM_COUNTER_COMPARE_A,EPWM_COMP_LOAD_ON_CNTR_ZERO);
	EPWM_enableSyncOutPulseSource(EPWM1_BASE,EPWM_SYNC_OUT_PULSE_ON_CNTR_ZERO);
    EPWM_setActionQualifierAction(EPWM1_BASE,
                                  EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
	EPWM_setActionQualifierAction(EPWM1_BASE,
                                  EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);


    SysCtl_enablePeripheral_TBCLKSYNC();
           EPWM_setHrpwmDllCfg0(PREEPWM_BASE,0x1);

    // Enable sync and clock to PWM
    //
    // SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);
}

/**
 * \brief   // initDMA - Configure DMA
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void initDMA()
{
    DMA_ConfigParams dmaCfg = {0};

    DMA_initController(DMA_BASE);

	/* Stop DMA channel first - why the DMA channel is still pending after reset? */
	DMA_stopChannel(DMA_CH1_BASE);
	dmaCfg.enableInterrupt = 1;
	dmaCfg.dmaSrcReqId = ReqID_ECAP;
	dmaCfg.srcAddr = (myECAP1_BASE + ECAP_O_CAP3); // ecap3Ĵַ
	dmaCfg.destAddr = (uint32_t)ecapData;
	dmaCfg.blockTS = 2;  // ÿֻ2ݣecap3ecap4һ
	dmaCfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
	dmaCfg.srcBtl  = DMA_BTL_8;
	dmaCfg.destBtl = DMA_BTL_8;
	dmaCfg.srcAddrDirect = DMA_ADDR_INCRE; // Ҫecap3ecap4ĴݣΪ
	dmaCfg.destAddrDirect = DMA_ADDR_INCRE;
	dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
	dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_4;
	dmaCfg.srcHkSelect = DMA_HKS_HARDWARE;
	dmaCfg.srcHardInf = DMA_HKS_HARD_INF_0;
	dmaCfg.reloadSrc = 1; // ԴַԶreloadɲblockжϣtfrж

	DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

	/* Clear INT flag set in previous operation */
	/* Enable the IRQ so that we can poll the Status_Tfr flag */
	DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_TFR | DMA_INT_BLOCK | DMA_INT_ERR);
	DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_TFR | DMA_INT_BLOCK | DMA_INT_ERR);

	/* DMA channel enable */
	DMA_startChannel(DMA_CH1_BASE);
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

void main(void){

	uint8_t status = 0;
	uint8_t reload_cnt = 0;
	uint32_t tmp32;

//	Device_init();

	// Board initialization
    // Configure GPIO 16 as eCAP input
    // Enable interrupts required for this example
    //
	Board_init();

	// Initialize counters
	cap3Count = 0U;
	cap4Count = 0U;

    // Configure ePWM
	initEPWM();

    // Configure DMA
    initDMA();

    while((status & DMA_INT_TFR) == 0)
		{
			status = DMA_getInterruptStatus(DMA_CH1_BASE);
			if (status & DMA_INT_BLOCK)
			{
				reload_cnt++;
				if (reload_cnt == ECAP_COUNT - 1)
					DMA_disableReload(DMA_CH1_BASE);//һǰرreloadһݴɲTFRж
				DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_BLOCK); //blocktsݺԴĴauto reloadͨclearжϴٴδ
			}
		}

    // Loop forever. Suspend or place breakpoints to observe the buffers.
    while(1)
    {
        cap3Count = ECAP_getEventTimeStamp(myECAP1_BASE, ECAP_EVENT_3);
        cap4Count = ECAP_getEventTimeStamp(myECAP1_BASE, ECAP_EVENT_4);
    }
}

/**
 * \brief   add brief description of this function
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif

