/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hrpwm_ex02_board.c
*   @brief
*   @details
*
*/

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "hrpwm_ex02_board.h"


//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	EALLOW;

	PinMux_init();
	EPWM1_init();
	EPWM2_init();
	EPWM3_init();
	EPWM4_init();

	EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
	//
	// PinMux for modules assigned to CPU1
	//

	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM2 -> myEPWM2 Pinmux
	//
	GPIO_setPinConfig(myEPWM2_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM2_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM2_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM2_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM2_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM2_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM3 -> myEPWM3 Pinmux
	//
	GPIO_setPinConfig(myEPWM3_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM3_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM3_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM3_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM3_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM3_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM4 -> myEPWM4 Pinmux
	//
	GPIO_setPinConfig(myEPWM4_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM4_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM4_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM4_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM4_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM4_EPWMB_GPIO, GPIO_QUAL_SYNC);


}

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM1_init()
{
	//HRPWM1
	//TB
	//  ģʽ
    HRPWM_setEmulationMode(myEPWM1_BASE, EPWM_EMULATION_FREE_RUN);
	//	ePWMʱ1Ƶ
	HRPWM_setClockPrescaler(myEPWM1_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	//	ģʽ¼
	HRPWM_setTimeBaseCounterMode(myEPWM1_BASE, EPWM_COUNTER_MODE_UP_DOWN);
	//	ֵTBPRD = 100
	EPWM_setTimeBasePeriod(myEPWM1_BASE, 100);
    //	ֵTBCTR = 0
	HRPWM_setTimeBaseCounter(myEPWM1_BASE, 0);
    //	ฺʧ
	EPWM_disablePhaseShiftLoad(myEPWM1_BASE);
    //	߾ฺʧ
    HRPWM_disablePhaseShiftLoad(myEPWM1_BASE);
    //	ֵTBPHS = 0  ߾ֵ: TBPHSHR = 0
	HRPWM_setPhaseShift(myEPWM1_BASE,0);


	//CC
	// 	ʹ CMPA1/B1 
	//	ʱͨACMPACMPBƣͨBCMPA1CMPB1
	EPWM_enableCounterCompare_Extend(myEPWM1_BASE);

	//Aͨ
    //	ñȽAֵCMPA = 45
	EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, 55);
    //	ñȽAļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPA
	HRPWM_setCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
    //	ñȽBֵCMPB = 45
	EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, 55);
    //	ñȽBļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPB
	HRPWM_setCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);

	//Bͨ
    //	ñȽA1ֵCMPA1 = 45
	EPWM_setCounterCompareValue_Extend(myEPWM1_BASE,EPWM_COUNTER_COMPARE_A1,55);
    //	ñȽA1ļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPA1
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM1_BASE,EPWM_COUNTER_COMPARE_A1,EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
    //	ñȽB1ֵCMPB1 = 45
	EPWM_setCounterCompareValue_Extend(myEPWM1_BASE,EPWM_COUNTER_COMPARE_B1,55);
    //	ñȽB1ļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPB1
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM1_BASE,EPWM_COUNTER_COMPARE_B1,EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);


	//AQ
	//Aͨ
    //	Aͨ¼: TBCTR = Up_CMPA -> ePWM1AHIGH
	HRPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼: TBCTR = Down_CMPB -> ePWM1ALOW
	HRPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);

	//Bͨ
    //	Bͨ¼: TBCTR = Up_CMPA1 -> ePWM1BHIGH
	HRPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA1);
    //	Bͨ¼: TBCTR = Down_CMPB1 -> ePWM1BLOW
	HRPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB1);


	//HR
	// 	ʹ CMPA1HR/B1HR 
	//	ʱͨAĸ߾CMPAHRCMPBHRƣͨBĸ߾CMPA1HRCMPB1HR
	HRPWM_enableCounterCompare_Extend(myEPWM1_BASE);
    //	ʹԶת
	HRPWM_enableAutoConversion(myEPWM1_BASE);

	//A Channel
    //	Aͨɸ߾ռձ CMPxHR  ߾ TBPRDHR 
    HRPWM_setMEPControlMode(myEPWM1_BASE,HRPWM_CHANNEL_A,HRPWM_MEP_DUTY_PERIOD_CTRL);
    //	Aͨʹ˫ؿ
	HRPWM_setMEPEdgeSelect(myEPWM1_BASE, HRPWM_CHANNEL_A, HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);
	//	ø߾ȼֵCMPAHR = 0
	HRPWM_setHiResCounterCompareValueOnly(myEPWM1_BASE, HRPWM_COUNTER_COMPARE_A, 0);
	//	ø߾ȼֵCMPBHR = 0
	HRPWM_setHiResCounterCompareValueOnly(myEPWM1_BASE, HRPWM_COUNTER_COMPARE_B, 0);


	//Bͨ
    //	Bͨɸ߾ռձ CMPxHR  ߾ TBPRDHR 
    HRPWM_setMEPControlMode(myEPWM1_BASE,HRPWM_CHANNEL_B,HRPWM_MEP_DUTY_PERIOD_CTRL);
    //	Bͨʹ˫ؿ
	HRPWM_setMEPEdgeSelect(myEPWM1_BASE, HRPWM_CHANNEL_B, HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);
	//	ø߾ȼֵCMPA1HR = 0
	HRPWM_setHiResCounterCompareValueOnly_Extend(myEPWM1_BASE,EPWM_COUNTER_COMPARE_A1,0);
	//	ø߾ȼֵCMPB1HR = 0
	HRPWM_setHiResCounterCompareValueOnly_Extend(myEPWM1_BASE,EPWM_COUNTER_COMPARE_B1,0);


	//	Aͨĸ߾ֵļģʽTBCTR = 0  TBCTR = TBPRD ʱµTBPRDHR
	HRPWM_setCounterCompareShadowLoadEvent(myEPWM1_BASE, HRPWM_CHANNEL_A, HRPWM_LOAD_ON_CNTR_ZERO_PERIOD);
	//	Bͨĸ߾ֵļģʽTBCTR = 0  TBCTR = TBPRD ʱµTBPRDHR
	HRPWM_setCounterCompareShadowLoadEvent(myEPWM1_BASE, HRPWM_CHANNEL_B, HRPWM_LOAD_ON_CNTR_ZERO_PERIOD);

}

void EPWM2_init()
{

	//HRPWM2
	//TB
	//  ģʽ
    HRPWM_setEmulationMode(myEPWM2_BASE, EPWM_EMULATION_FREE_RUN);
	//	ePWMʱ1Ƶ
	HRPWM_setClockPrescaler(myEPWM2_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	//	ģʽ¼
	HRPWM_setTimeBaseCounterMode(myEPWM2_BASE, EPWM_COUNTER_MODE_UP_DOWN);
	//	ֵTBPRD = 100
	EPWM_setTimeBasePeriod(myEPWM2_BASE, 100);
    //	ֵTBCTR = 0
	HRPWM_setTimeBaseCounter(myEPWM2_BASE, 0);
    //	ฺʧ
	EPWM_disablePhaseShiftLoad(myEPWM2_BASE);
    //	߾ฺʧ
    HRPWM_disablePhaseShiftLoad(myEPWM2_BASE);
    //	ֵTBPHS = 0  ߾ֵ: TBPHSHR = 0
	HRPWM_setPhaseShift(myEPWM2_BASE,0);

	//CC
	// 	ʹ CMPA1/B1 
	//	ʱͨACMPACMPBƣͨBCMPA1CMPB1
	EPWM_enableCounterCompare_Extend(myEPWM2_BASE);

	//Aͨ
    //	ñȽAֵCMPA = 45
	EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_A, 55);
    //	ñȽAļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPA
	HRPWM_setCounterCompareShadowLoadMode(myEPWM2_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
    //	ñȽBֵCMPB = 45
	EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_B, 55);
    //	ñȽBļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPB
	HRPWM_setCounterCompareShadowLoadMode(myEPWM2_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);


	//Bͨ
    //	ñȽA1ֵCMPA1 = 45
	EPWM_setCounterCompareValue_Extend(myEPWM2_BASE,EPWM_COUNTER_COMPARE_A1,55);
    //	ñȽA1ļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPA1
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM2_BASE,EPWM_COUNTER_COMPARE_A1,EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
    //	ñȽB1ֵCMPB1 = 45
	EPWM_setCounterCompareValue_Extend(myEPWM2_BASE,EPWM_COUNTER_COMPARE_B1,55);
    //	Load the new CMPB1 when TBCTR = 0 and TBCTR = TBPRD
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM2_BASE,EPWM_COUNTER_COMPARE_B1,EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);


	//AQ
	//Aͨ
    //	Aͨ¼: TBCTR = Up_CMPA -> ePWM2AHIGH
	HRPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼: TBCTR = Down_CMPB -> ePWM2ALOW
	HRPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);

	//Bͨ
    //	Bͨ¼: TBCTR = Down_CMPB1 -> ePWM2BHIGH
	HRPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA1);
    //	Bͨ¼: TBCTR = Up_CMPA1 -> ePWM2BLOW
	HRPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB1);


	//HR
	// 	ʹ CMPA1HR/B1HR 
	//	ʱͨAĸ߾CMPAHRCMPBHRƣͨBĸ߾CMPA1HRCMPB1HR
	HRPWM_enableCounterCompare_Extend(myEPWM2_BASE);
    //	ʹԶת
	HRPWM_enableAutoConversion(myEPWM2_BASE);

	//Aͨ
    //	Aͨɸ߾ռձ CMPxHR  ߾ TBPRDHR 
    HRPWM_setMEPControlMode(myEPWM2_BASE,HRPWM_CHANNEL_A,HRPWM_MEP_DUTY_PERIOD_CTRL);
    //	Aͨʹ˫ؿ
	HRPWM_setMEPEdgeSelect(myEPWM2_BASE, HRPWM_CHANNEL_A, HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);
	//	ø߾ȼֵCMPAHR = 0
	HRPWM_setHiResCounterCompareValueOnly(myEPWM2_BASE, HRPWM_COUNTER_COMPARE_A, 0);
	//	ø߾ȼֵCMPBHR = 0
	HRPWM_setHiResCounterCompareValueOnly(myEPWM2_BASE, HRPWM_COUNTER_COMPARE_B, 0);




	//Bͨ
    //	Bͨɸ߾ռձ CMPxHR  ߾ TBPRDHR 
    HRPWM_setMEPControlMode(myEPWM2_BASE,HRPWM_CHANNEL_B,HRPWM_MEP_DUTY_PERIOD_CTRL);
    //	Bͨʹ˫ؿ
	HRPWM_setMEPEdgeSelect(myEPWM2_BASE, HRPWM_CHANNEL_B, HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);
	//	ø߾ȼֵCMPA1HR = 0
	HRPWM_setHiResCounterCompareValueOnly_Extend(myEPWM2_BASE,EPWM_COUNTER_COMPARE_A1,0);
	//	ø߾ȼֵCMPB1HR = 0
	HRPWM_setHiResCounterCompareValueOnly_Extend(myEPWM2_BASE,EPWM_COUNTER_COMPARE_B1,0);


	//	Aͨĸ߾ֵļģʽTBCTR = 0  TBCTR = TBPRD ʱµTBPRDHR
	HRPWM_setCounterCompareShadowLoadEvent(myEPWM2_BASE, HRPWM_CHANNEL_A, HRPWM_LOAD_ON_CNTR_ZERO);
	//	Bͨĸ߾ֵļģʽTBCTR = 0  TBCTR = TBPRD ʱµTBPRDHR
	HRPWM_setCounterCompareShadowLoadEvent(myEPWM2_BASE, HRPWM_CHANNEL_B, HRPWM_LOAD_ON_CNTR_ZERO);


}

void EPWM3_init()
{
	//HRPWM3
	//TB
	//  ģʽ
    HRPWM_setEmulationMode(myEPWM3_BASE, EPWM_EMULATION_FREE_RUN);
	//	ePWMʱ1Ƶ
	HRPWM_setClockPrescaler(myEPWM3_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	//	ģʽ¼
	HRPWM_setTimeBaseCounterMode(myEPWM3_BASE, EPWM_COUNTER_MODE_UP_DOWN);
	//	ֵTBPRD = 100
	EPWM_setTimeBasePeriod(myEPWM3_BASE, 100);
    //	ֵTBCTR = 0
	HRPWM_setTimeBaseCounter(myEPWM3_BASE, 0);
    //	ฺʧ
	EPWM_disablePhaseShiftLoad(myEPWM3_BASE);
    //	߾ฺʧ
    HRPWM_disablePhaseShiftLoad(myEPWM3_BASE);
    //	ֵTBPHS = 0  ߾ֵ: TBPHSHR = 0
	HRPWM_setPhaseShift(myEPWM3_BASE,0);


	//CC
	// 	ʹ CMPA1/B1 
	//	ʱͨACMPACMPBƣͨBCMPA1CMPB1
	EPWM_enableCounterCompare_Extend(myEPWM3_BASE);

	//A Channel
    //	ñȽAֵCMPA = 45
	EPWM_setCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_A, 55);
    //	ñȽAļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPA
	HRPWM_setCounterCompareShadowLoadMode(myEPWM3_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
    //	ñȽBֵCMPB = 45
	EPWM_setCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_B, 55);
    //	ñȽBļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPB
	HRPWM_setCounterCompareShadowLoadMode(myEPWM3_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);

	//Bͨ
    //	ñȽA1ֵCMPA1 = 45
	EPWM_setCounterCompareValue_Extend(myEPWM3_BASE,EPWM_COUNTER_COMPARE_A1,55);
    //	ñȽA1ļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPA1
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM3_BASE,EPWM_COUNTER_COMPARE_A1,EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
    //	ñȽB1ֵCMPB1 = 45
	EPWM_setCounterCompareValue_Extend(myEPWM3_BASE,EPWM_COUNTER_COMPARE_B1,55);
    //	ñȽB1ļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPB1
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM3_BASE,EPWM_COUNTER_COMPARE_B1,EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);


	//AQ
	//Aͨ
    //	Aͨ¼: TBCTR = Up_CMPA -> ePWM3AHIGH
	HRPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼: TBCTR = Down_CMPB -> ePWM3ALOW
	HRPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);

	//Bͨ
    //	Bͨ¼: TBCTR = UP_CMPA1 -> ePWM3BHIGH
	HRPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA1);
    //	Aͨ¼: TBCTR = Down_CMPB1 -> ePWM3ALOW
	HRPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB1);


	//HR
	// 	ʹ CMPA1HR/B1HR 
	//	ʱͨAĸ߾CMPAHRCMPBHRƣͨBĸ߾CMPA1HRCMPB1HR
	HRPWM_enableCounterCompare_Extend(myEPWM3_BASE);
    //	ʧԶת
	HRPWM_disableAutoConversion(myEPWM3_BASE);

	//A Channel
    //	Aͨɸ߾ռձ CMPxHR  ߾ TBPRDHR 
    HRPWM_setMEPControlMode(myEPWM3_BASE,HRPWM_CHANNEL_A,HRPWM_MEP_DUTY_PERIOD_CTRL);
    //	Aͨʹ˫ؿ
	HRPWM_setMEPEdgeSelect(myEPWM3_BASE, HRPWM_CHANNEL_A, HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);
	//	ø߾ȼֵCMPAHR = 0
	HRPWM_setHiResCounterCompareValueOnly(myEPWM3_BASE, HRPWM_COUNTER_COMPARE_A, 0);
	//	ø߾ȼֵCMPBHR = 0
	HRPWM_setHiResCounterCompareValueOnly(myEPWM3_BASE, HRPWM_COUNTER_COMPARE_B, 0);


	//Bͨ
    //	Bͨɸ߾ռձ CMPxHR  ߾ TBPRDHR 
    HRPWM_setMEPControlMode(myEPWM3_BASE,HRPWM_CHANNEL_B,HRPWM_MEP_DUTY_PERIOD_CTRL);
    //	Bͨʹ˫ؿ
	HRPWM_setMEPEdgeSelect(myEPWM3_BASE, HRPWM_CHANNEL_B, HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);
	//	ø߾ȼֵCMPA1HR = 0
	HRPWM_setHiResCounterCompareValueOnly_Extend(myEPWM3_BASE,EPWM_COUNTER_COMPARE_A1,0);
	//	ø߾ȼֵCMPB1HR = 0
	HRPWM_setHiResCounterCompareValueOnly_Extend(myEPWM3_BASE,EPWM_COUNTER_COMPARE_B1,0);


	//	Aͨĸ߾ֵļģʽTBCTR = 0  TBCTR = TBPRD ʱµTBPRDHR
	HRPWM_setCounterCompareShadowLoadEvent(myEPWM3_BASE, HRPWM_CHANNEL_A, HRPWM_LOAD_ON_CNTR_ZERO_PERIOD);
	//	Bͨĸ߾ֵļģʽTBCTR = 0  TBCTR = TBPRD ʱµTBPRDHR
	HRPWM_setCounterCompareShadowLoadEvent(myEPWM3_BASE, HRPWM_CHANNEL_B, HRPWM_LOAD_ON_CNTR_ZERO_PERIOD);

}

void EPWM4_init()
{

	//HRPWM4
	//TB
	//  ģʽ
    HRPWM_setEmulationMode(myEPWM4_BASE, EPWM_EMULATION_FREE_RUN);
	//	ePWMʱ1Ƶ
	HRPWM_setClockPrescaler(myEPWM4_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	//	ģʽ¼
	HRPWM_setTimeBaseCounterMode(myEPWM4_BASE, EPWM_COUNTER_MODE_UP_DOWN);
	//	ֵTBPRD = 100
	EPWM_setTimeBasePeriod(myEPWM4_BASE, 100);
    //	ֵTBCTR = 0
	HRPWM_setTimeBaseCounter(myEPWM4_BASE, 0);
    //	ฺʧ
	EPWM_disablePhaseShiftLoad(myEPWM4_BASE);
    //	߾ฺʧ
    HRPWM_disablePhaseShiftLoad(myEPWM4_BASE);
    //	ֵTBPHS = 0  ߾ֵ: TBPHSHR = 0
	HRPWM_setPhaseShift(myEPWM4_BASE,0);

	//CC
	// 	ʹ CMPA1/B1 
	//	ʱͨACMPACMPBƣͨBCMPA1CMPB1
	EPWM_enableCounterCompare_Extend(myEPWM4_BASE);

	//Aͨ
    //	ñȽAֵCMPA = 45
	EPWM_setCounterCompareValue(myEPWM4_BASE, EPWM_COUNTER_COMPARE_A, 55);
    //	ñȽAļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPA
	HRPWM_setCounterCompareShadowLoadMode(myEPWM4_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
	 // ñȽBֵCMPB = 45
	EPWM_setCounterCompareValue(myEPWM4_BASE, EPWM_COUNTER_COMPARE_B, 55);
    //	ñȽBļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPB
	HRPWM_setCounterCompareShadowLoadMode(myEPWM4_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);

	//Bͨ
    //	ñȽA1ֵCMPA1 = 45
	EPWM_setCounterCompareValue_Extend(myEPWM4_BASE,EPWM_COUNTER_COMPARE_A1,55);
    //	ñȽA1ļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPA1
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM4_BASE,EPWM_COUNTER_COMPARE_A1,EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
    //	ñȽB1ֵCMPB1 = 45
	EPWM_setCounterCompareValue_Extend(myEPWM4_BASE,EPWM_COUNTER_COMPARE_B1,55);
    //	ñȽB1ļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPB1
	EPWM_setCounterCompareShadowLoadMode_Extend(myEPWM4_BASE,EPWM_COUNTER_COMPARE_B1,EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);


	//AQ
	//Aͨ
    //	Aͨ¼: TBCTR = Up_CMPA -> ePWM4AHIGH
	HRPWM_setActionQualifierAction(myEPWM4_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼: TBCTR = Down_CMPB -> ePWM4ALOW
	HRPWM_setActionQualifierAction(myEPWM4_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);

	//Bͨ
    //	Bͨ¼: TBCTR = Down_CMPB1 -> ePWM4BHIGH
	HRPWM_setActionQualifierAction(myEPWM4_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA1);
    //	Bͨ¼: TBCTR = UP_CMPA1 -> ePWM4BLOW
	HRPWM_setActionQualifierAction(myEPWM4_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB1);


	//HR
	// 	ʹ CMPA1HR/B1HR 
	//	ʱͨAĸ߾CMPAHRCMPBHRƣͨBĸ߾CMPA1HRCMPB1HR
	HRPWM_enableCounterCompare_Extend(myEPWM4_BASE);
    //	ʧԶת
	HRPWM_disableAutoConversion(myEPWM4_BASE);

	//Aͨ
    //	Aͨɸ߾ռձ CMPxHR  ߾ TBPRDHR 
    HRPWM_setMEPControlMode(myEPWM4_BASE,HRPWM_CHANNEL_A,HRPWM_MEP_DUTY_PERIOD_CTRL);
    //	Aͨʹ˫ؿ
	HRPWM_setMEPEdgeSelect(myEPWM4_BASE, HRPWM_CHANNEL_A, HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);
	//	ø߾ȼֵCMPAHR = 0
	HRPWM_setHiResCounterCompareValueOnly(myEPWM4_BASE, HRPWM_COUNTER_COMPARE_A, 0);
	//	ø߾ȼֵCMPBHR = 0
	HRPWM_setHiResCounterCompareValueOnly(myEPWM4_BASE, HRPWM_COUNTER_COMPARE_B, 0);


	//Bͨ
    //	Bͨɸ߾ռձ CMPxHR  ߾ TBPRDHR 
    HRPWM_setMEPControlMode(myEPWM4_BASE,HRPWM_CHANNEL_B,HRPWM_MEP_DUTY_PERIOD_CTRL);
    //	Bͨʹ˫ؿ
	HRPWM_setMEPEdgeSelect(myEPWM4_BASE, HRPWM_CHANNEL_B, HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);
	//	ø߾ȼֵCMPA1HR = 0
	HRPWM_setHiResCounterCompareValueOnly_Extend(myEPWM4_BASE,EPWM_COUNTER_COMPARE_A1,0);
	//	ø߾ȼֵCMPB1HR = 0
	HRPWM_setHiResCounterCompareValueOnly_Extend(myEPWM4_BASE,EPWM_COUNTER_COMPARE_B1,0);


	//	Aͨĸ߾ֵļģʽTBCTR = 0  TBCTR = TBPRD ʱµTBPRDHR
	HRPWM_setCounterCompareShadowLoadEvent(myEPWM4_BASE, HRPWM_CHANNEL_A, HRPWM_LOAD_ON_CNTR_ZERO_PERIOD);
	//	Bͨĸ߾ֵļģʽTBCTR = 0  TBCTR = TBPRD ʱµTBPRDHR
	HRPWM_setCounterCompareShadowLoadEvent(myEPWM4_BASE, HRPWM_CHANNEL_B, HRPWM_LOAD_ON_CNTR_ZERO_PERIOD);


}


