/*
 * 	File: hrpwm_ex04_prd_duty_sfo_Extend
 *
 *	ʾHRPWMĸ߾+߾ռձȿЧ
 *
 *	 EPWM_TIMER_UP_DOWN_TBPRD  ֵλ
 *
 *	 periodFine 	->		ֵСλ
 *
 *	 duty			->		ռձ
 *
 *	ͨ IDE  periodFine  duty,Ȼ ePWM1/2/3/4_Controls Ϊ 1 ݸ
 *
 *	ʾePWM1A ->IO0ePWM1B->IO1۲첨ռձȺ (֤)
 *
 *	ʾePWM2A ->IO2ePWM2B->IO3۲첨ռձȺ (CC)
 *
 *	ʾePWM3A ->IO4ePWM2B->IO5۲첨ռձȺ (DB)
 *
 *	ʾePWM4A ->IO6ePWM4B->IO7۲첨ռձȺ (ͬ)
 *
 *
 *
 *
*/


/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "hrpwm_ex04_board.h"
#include "SFO_v2.h"


//λ
#define EPWM_TIMER_UP_DOWN_TBPRD            100UL
//ССλ
#define MIN_HRPWM_PRD_PERCENT   	   		0.2

//SOF״̬
SFO_Status_t SFO_Status;
//SOFṹ
SFO_Params_t SFO_Params;

//Сλ
float32_t periodFine = MIN_HRPWM_PRD_PERCENT;
float32_t duty = 50.6;

//ePWN1λ
volatile uint8_t ePWM1_Controls = 1;
//ePWN2λ
volatile uint8_t ePWM2_Controls = 1;
//ePWN3λ
volatile uint8_t ePWM3_Controls = 1;
//ePWN4λ
volatile uint8_t ePWM4_Controls = 1;

void error (void);

void HRPWM_Update_HrDuty_Center(uint32_t Epwmbase,HRPWM_CounterCompareModule channel,float32_t period,float32_t duty);


int main(void)
{
    //
    // Initialize device clock and peripherals
    //
    Device_init();


    //
    // Calling SFO() updates the HRMSTEP register with calibrated MEP_ScaleFactor.
    // HRMSTEP must be populated with a scale factor value prior to enabling
    // high resolution period control.
    //
    SFO_Struct_init(&SFO_Params,5);

    do
    {
    	SFO_Status = SFO(&SFO_Params);

        if(SFO_Success != SFO_Status)
        {
            error();   	//Look at the enumeration type to see the error type
        }
    }while(SFO_Status != SFO_Success);



    //
    // Disable sync(Freeze clock to PWM as well)
    //
    SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);


    //
    // Initialize the EPWM GPIO Pins and change the XBAR inputs from using GPIO0
    //
    Board_init();

    //
    // Enable sync and clock to PWM
    //
	SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    //
    // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
    //
    EINT;
    ERTM;

    while (1)
    {

    	SFO_Status = SFO(&SFO_Params);

    	if( ePWM1_Controls == 1 )    		// Up_Down Mode
    	{
    		ePWM1_Controls = 0;

    		//prdiod
            float32_t count = (EPWM_TIMER_UP_DOWN_TBPRD << 8UL) + (float32_t)(periodFine * 256);
            uint32_t compCount = count;
            HRPWM_setTimeBasePeriod(myEPWM1_BASE, compCount);

            //duty
            HRPWM_Update_HrDuty_Center(myEPWM1_BASE,HRPWM_COUNTER_COMPARE_A,EPWM_TIMER_UP_DOWN_TBPRD - periodFine,(100 - duty));

    	}else if( ePWM2_Controls == 1 )		// Up_Down CC-AQ  Dead zone complementarity
    	{

    		ePWM2_Controls = 0;

    		//prdiod
            float32_t count = (EPWM_TIMER_UP_DOWN_TBPRD << 8UL) + (float32_t)(periodFine * 256);
            uint32_t compCount = count;
            HRPWM_setTimeBasePeriod(myEPWM2_BASE, compCount);

            //duty
            HRPWM_Update_HrDuty_Center(myEPWM2_BASE,HRPWM_COUNTER_COMPARE_A,EPWM_TIMER_UP_DOWN_TBPRD - periodFine,(100 - duty));


    	}else if( ePWM3_Controls == 1 )		// Up_Down DB  Dead zone complementarity
    	{

    		ePWM3_Controls = 0;

    		//prdiod
            float32_t count = (EPWM_TIMER_UP_DOWN_TBPRD << 8UL) + (float32_t)(periodFine * 256);
            uint32_t compCount = count;
            uint32_t DB_Count = 10;
            HRPWM_setTimeBasePeriod(myEPWM3_BASE, compCount);

            //duty
            HRPWM_Update_HrDuty_Center(myEPWM3_BASE,HRPWM_COUNTER_COMPARE_A,EPWM_TIMER_UP_DOWN_TBPRD - periodFine,(100 - duty));
            EPWM_setRisingEdgeDelayCount(myEPWM3_BASE, DB_Count);
            EPWM_setFallingEdgeDelayCount(myEPWM3_BASE, DB_Count+1);

    	}else if( ePWM4_Controls == 1 )
    	{
    		ePWM4_Controls = 0;

    		//prdiod
            float32_t count = (EPWM_TIMER_UP_DOWN_TBPRD << 8UL) + (float32_t)(periodFine * 256);
            uint32_t compCount = count;
            HRPWM_setTimeBasePeriod(myEPWM4_BASE, compCount);

            //duty
            HRPWM_Update_HrDuty_Center(myEPWM4_BASE,HRPWM_COUNTER_COMPARE_A,EPWM_TIMER_UP_DOWN_TBPRD - periodFine,(EPWM_TIMER_UP_DOWN_TBPRD - duty));
            HRPWM_Update_HrDuty_Center(myEPWM4_BASE,HRPWM_COUNTER_COMPARE_B,EPWM_TIMER_UP_DOWN_TBPRD - periodFine,(EPWM_TIMER_UP_DOWN_TBPRD - duty));
    	}

    }

    return 0;
}


//
// error - Halt debugger when called
//
void error (void)
{
    ESTOP0;         // Stop here and handle error
}




void HRPWM_Update_HrDuty_Center(uint32_t Epwmbase,HRPWM_CounterCompareModule channel,float32_t period,float32_t duty)
{
	uint16_t  Hrstep = 0;
	uint16_t  SetCMPA_A1 = 0 ,SetCMPHRA_A1 = 0;
	uint16_t  SetCMPB_B1 = 0 ,SetCMPHRB_B1 = 0;
	uint16_t  HR_mstep = 0;
	uint8_t   Auto_Flag = 0;


	Auto_Flag = HWREGH(Epwmbase + HRPWM_O_HRCNFG) & HRPWM_HRCNFG_AUTOCONV;

	if(Auto_Flag)
	{
		HR_mstep = 256U;

	}else
	{
		HR_mstep = HWREGB(Epwmbase + HRPWM_O_HRMSTEP);
	}


	SetCMPA_A1   = (uint16_t)(duty/100.0f*period);
	SetCMPHRA_A1 = (uint16_t)((duty/100.0f*period - SetCMPA_A1) * HR_mstep + 0.5);

	SetCMPB_B1   = SetCMPA_A1+1;
	SetCMPHRB_B1 = HR_mstep - SetCMPHRA_A1;

	if(!(SetCMPHRB_B1%HR_mstep))
	{
		SetCMPHRB_B1 -= 1;
	}

	if( HRPWM_COUNTER_COMPARE_A == channel )
	{
		HRPWM_setCounterCompareValue(Epwmbase,HRPWM_COUNTER_COMPARE_A,(SetCMPA_A1<<8)|SetCMPHRA_A1);
		HRPWM_setCounterCompareValue(Epwmbase,HRPWM_COUNTER_COMPARE_B,(SetCMPB_B1<<8)|SetCMPHRB_B1);

	}else
	{
		HRPWM_setCounterCompareValue_Extend(Epwmbase,HRPWM_COUNTER_COMPARE_A1,(SetCMPA_A1<<8)|SetCMPHRA_A1);
		HRPWM_setCounterCompareValue_Extend(Epwmbase,HRPWM_COUNTER_COMPARE_B1,(SetCMPB_B1<<8)|SetCMPHRB_B1);
	}


}



