/*
 * 	File: hrpwm_ex06_duty_updown_sfo_Extend
 *
 *	ʾUP_DownģʽHRPWMĸ߾ռձȿЧ
 *
 *  ePWM1ePWM2ʹõԶģʽePWM3ePWM4ʹֶģʽ
 *
 *  ʾePWM1A ->IO0ePWM1B->IO1۲첨
 *  ʾePWM2A ->IO2ePWM2B->IO3۲첨
 *  ʾePWM3A ->IO4ePWM3B->IO5۲첨
 *  ʾePWM4A ->IO6ePWM4B->IO7۲첨
 *
 *	duty_ePWMx   -> ռձ
 *	EPWM_TIMER_UO_DOWN_TBPRD	->  ֵ
 *
 *
 *	ͨ IDE  duty_ePWMx,Ȼ ePWMx_Controlsx Ϊ 1 ݸ
 *
 *
 *
 *
*/
/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "hrpwm_ex06_board.h"
#include "SFO_v2.h"



#define EPWM_TIMER_UO_DOWN_TBPRD       100UL

//SFO״̬
SFO_Status_t SFO_Status;
//SFOϢ
SFO_Params_t SFO_Params;

//ePWM1λ
volatile uint8_t ePWM1_Controls = 1;
//ePWM2λ
volatile uint8_t ePWM2_Controls = 1;
//ePWM3λ
volatile uint8_t ePWM3_Controls = 1;
//ePWM4λ
volatile uint8_t ePWM4_Controls = 1;

void error (void);

const float duty = 45.0f;

//ePMW1ռձ
volatile float duty_ePWM1 = duty;
//ePMW2ռձ
volatile float duty_ePWM2 = duty;
//ePMW3ռձ
volatile float duty_ePWM3 = duty;
//ePMW4ռձ
volatile float duty_ePWM4 = duty;

int main(void)
{
    //
    // Initialize device clock and peripherals
    //
    Device_init();

    HRPWM_enableUpDownInit_Compatible(HRPWM1_Enabled|HRPWM2_Enabled|HRPWM3_Enabled|HRPWM4_Enabled);
    //
    // Calling SFO() updates the HRMSTEP register with calibrated MEP_ScaleFactor.
    // HRMSTEP must be populated with a scale factor value prior to enabling
    // high resolution period control.
    //
    SFO_Struct_init(&SFO_Params,5);
    do
    {
    	SFO_Status = SFO(&SFO_Params);

        if(SFO_Success != SFO_Status)
        {
            error();   	//Look at the enumeration type to see the error type
        }
    }while(SFO_Status != SFO_Success);



    //
    // Disable sync(Freeze clock to PWM as well)
    //
    SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);


    //
    // Initialize the EPWM GPIO Pins and change the XBAR inputs from using GPIO0
    //
    Board_init();

    //
    // Enable sync and clock to PWM
    //
	SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    //
    // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
    //
    EINT;
    ERTM;

    while (1)
    {

    	SFO_Status = SFO(&SFO_Params);


    	if( ePWM1_Controls == 1 )    	// Auto
    	{
    		ePWM1_Controls = 0;
    		float32_t Count = (float32_t)EPWM_TIMER_UO_DOWN_TBPRD*(100.0f-duty_ePWM1)/100.0f*256;
    		HRPWM_setCounterCompareValue_Compatible(myEPWM1_BASE,HRPWM_COUNTER_COMPARE_A,(uint32_t)Count);
    		HRPWM_setCounterCompareValue_Compatible(myEPWM1_BASE,HRPWM_COUNTER_COMPARE_B,(uint32_t)Count);

    	}else if( ePWM2_Controls == 1 )    	// Auto
    	{
    		ePWM2_Controls = 0;
    		float32_t Count = (float32_t)EPWM_TIMER_UO_DOWN_TBPRD*(100.0f-duty_ePWM2)/100.0f*256;
    		HRPWM_setCounterCompareValue_Compatible(myEPWM2_BASE,HRPWM_COUNTER_COMPARE_A,(uint32_t)Count);
    		HRPWM_setCounterCompareValue_Compatible(myEPWM2_BASE,HRPWM_COUNTER_COMPARE_B,(uint32_t)Count);

    	}else if( ePWM3_Controls == 1 )    	// Not Auto
    	{
    		ePWM3_Controls = 0;
    		float32_t Count = (float32_t)EPWM_TIMER_UO_DOWN_TBPRD*(duty_ePWM3)/100.0f*256;
    		HRPWM_setCounterCompareValue_Compatible(myEPWM3_BASE,HRPWM_COUNTER_COMPARE_A,(uint32_t)Count);
    		HRPWM_setCounterCompareValue_Compatible(myEPWM3_BASE,HRPWM_COUNTER_COMPARE_B,(uint32_t)Count);

    	}else if( ePWM4_Controls == 1 )    	// Not Auto
    	{
    		ePWM4_Controls = 0;
    		float32_t Count = (float32_t)EPWM_TIMER_UO_DOWN_TBPRD*(duty_ePWM4)/100.0f*256;
    		HRPWM_setCounterCompareValue_Compatible(myEPWM4_BASE,HRPWM_COUNTER_COMPARE_A,(uint32_t)Count);
    		HRPWM_setCounterCompareValue_Compatible(myEPWM4_BASE,HRPWM_COUNTER_COMPARE_B,(uint32_t)Count);

    	}

    }

    return 0;
}


//
// error - Halt debugger when called
//
void error (void)
{
    ESTOP0;         // Stop here and handle error
}






