

    .global knlCurrentTaskTCB
    .global knlNextTaskTCB
    
    .global knlStartTask
    .global knlCtxSw
    .global knlIntCtxSw

    .global Software_IRQHandler

#********************************************************************************************************
#                                               EQUATES
#********************************************************************************************************

    .equ  RISCV_MSTATUS_MIE,         0x08

    .equ  RISCV_MIE_MSIE,            0x08            # M Soft Interrupt bit

#if BOOT_HARTID == 1
    #2.2 dsp slave
    .equ  RISCV_PRCI_BASE_ADDR,      0xE1031004
#else
    .equ  RISCV_PRCI_BASE_ADDR,      0xE1030FFC
#endif

#*******************************************************************************
#knlStartTask()
#start high ready task
#*******************************************************************************
	.section .RamFunc, "ax"
knlStartTask:
# Disable interrupts
    li     t0, RISCV_MSTATUS_MIE
    csrrc  zero, mstatus, t0

# SWITCH TO HIGHEST PRIORITY TASK
    la     t0, knlCurrentTaskTCB
    lw     t1, 0(t0)
    lw     sp, 0(t1)

#if !(OS_SAVE_FPU_CONTEXT_DISABLE >0)
	# Compensate for the stack pointer
    addi   sp, sp, 33 * 4
#endif

# Retrieve the location where to jump
    lw     t0, 0 * 4(sp)
    csrw   mepc, t0

# Pop mstatus from stack and set it
	lw     t0, 29 * 4(sp)
    csrw   mstatus, t0

# Restore x1 to x31 registers
    lw     ra,   1 * 4(sp)
    lw     t0,   2 * 4(sp)
    lw     t1,   3 * 4(sp)
    lw     t2,   4 * 4(sp)
    lw     s0,   5 * 4(sp)
    lw     s1,   6 * 4(sp)
    lw     a0,   7 * 4(sp)
    lw     a1,   8 * 4(sp)
    lw     a2,   9 * 4(sp)
    lw     a3,  10 * 4(sp)
    lw     a4,  11 * 4(sp)
    lw     a5,  12 * 4(sp)
    lw     a6,  13 * 4(sp)
    lw     a7,  14 * 4(sp)
    lw     s2,  15 * 4(sp)
    lw     s3,  16 * 4(sp)
    lw     s4,  17 * 4(sp)
    lw     s5,  18 * 4(sp)
    lw     s6,  19 * 4(sp)
    lw     s7,  20 * 4(sp)
    lw     s8,  21 * 4(sp)
    lw     s9,  22 * 4(sp)
    lw     s10, 23 * 4(sp)
    lw     s11, 24 * 4(sp)
    lw     t3,  25 * 4(sp)
    lw     t4,  26 * 4(sp)
    lw     t5,  27 * 4(sp)
    lw     t6,  28 * 4(sp)

# Compensate for the stack pointer
    addi   sp, sp, 30 * 4

# Use register t6 to jump to HIGHEST priority
    csrr   t6, mepc

# Enable global interrupts
    li     t0, RISCV_MSTATUS_MIE
    csrrs  zero, mstatus, t0

# Jump to HIGHEST priority task.
    jalr   x0, t6, 0

#*******************************************************************************
#knlCtxSw
#task level sw
#*******************************************************************************

Software_IRQHandler:
# save x1 to x31 registers
    addi   sp, sp, -4 * 30

    sw     ra,   1 * 4(sp)
    sw     t0,   2 * 4(sp)
    sw     t1,   3 * 4(sp)
    sw     t2,   4 * 4(sp)
    sw     s0,   5 * 4(sp)
    sw     s1,   6 * 4(sp)
    sw     a0,   7 * 4(sp)
    sw     a1,   8 * 4(sp)
    sw     a2,   9 * 4(sp)
    sw     a3,  10 * 4(sp)
    sw     a4,  11 * 4(sp)
    sw     a5,  12 * 4(sp)
    sw     a6,  13 * 4(sp)
    sw     a7,  14 * 4(sp)
    sw     s2,  15 * 4(sp)
    sw     s3,  16 * 4(sp)
    sw     s4,  17 * 4(sp)
    sw     s5,  18 * 4(sp)
    sw     s6,  19 * 4(sp)
    sw     s7,  20 * 4(sp)
    sw     s8,  21 * 4(sp)
    sw     s9,  22 * 4(sp)
    sw     s10, 23 * 4(sp)
    sw     s11, 24 * 4(sp)
    sw     t3,  25 * 4(sp)
    sw     t4,  26 * 4(sp)
    sw     t5,  27 * 4(sp)
    sw     t6,  28 * 4(sp)

    csrr   t0,  mstatus
    sw     t0,  29 * 4(sp)

    csrr   t0, mepc
    sw     t0, 0*4(sp)

# Disable interrupts globally and prevent interruption during context switch
#    li     t0, RISCV_MSTATUS_MIE
#    csrrc  zero, mstatus, t0

/* Push additional FPU registers */
#if !(OS_SAVE_FPU_CONTEXT_DISABLE >0)
	# Compensate for the stack pointer
    addi   sp, sp, -4 * 33

    fsw    f0,   0 * 4(sp)
    fsw    f1,   1 * 4(sp)
    fsw    f2,   2 * 4(sp)
    fsw    f3,   3 * 4(sp)
    fsw    f4,   4 * 4(sp)
    fsw    f5,   5 * 4(sp)
    fsw    f6,   6 * 4(sp)
    fsw    f7,   7 * 4(sp)
    fsw    f8,   8 * 4(sp)
    fsw    f9,   9 * 4(sp)
    fsw    f10, 10 * 4(sp)
    fsw    f11, 11 * 4(sp)
    fsw    f12, 12 * 4(sp)
    fsw    f13, 13 * 4(sp)
    fsw    f14, 14 * 4(sp)
    fsw    f15, 15 * 4(sp)
    fsw    f16, 16 * 4(sp)
    fsw    f17, 17 * 4(sp)
    fsw    f18, 18 * 4(sp)
    fsw    f19, 19 * 4(sp)
    fsw    f20, 20 * 4(sp)
    fsw    f21, 21 * 4(sp)
    fsw    f22, 22 * 4(sp)
    fsw    f23, 23 * 4(sp)
    fsw    f24, 24 * 4(sp)
    fsw    f25, 25 * 4(sp)
    fsw    f26, 26 * 4(sp)
    fsw    f27, 27 * 4(sp)
    fsw    f28, 28 * 4(sp)
    fsw    f29, 29 * 4(sp)
    fsw    f30, 30 * 4(sp)
    fsw    f31, 31 * 4(sp)

    csrr   t0,  fcsr
    sw     t0,  32 * 4(sp)
#endif
# Clear soft interrupt for hart0, PRCI->MSIP[0] = 0x00;
    li     t0, RISCV_PRCI_BASE_ADDR
    sw     zero, 0x0(t0)

# knlCurrentTaskTCB->tcbStackPtr = SP;
    la     t0, knlCurrentTaskTCB
    lw     t1, 0(t0)
    sw     sp, 0(t1)

# SP = knlNextTaskTCB->tcbStackPtr;
    la     t2, knlNextTaskTCB
    lw     t1, 0(t2)
    lw     sp, 0(t1)

# knlCurrentTaskTCB = knlNextTaskTCB;
    sw     t1, 0(t0)

/* Pop additional FPU registers */
#if !(OS_SAVE_FPU_CONTEXT_DISABLE >0)
	flw    f0,   0 * 4(sp)
    flw    f1,   1 * 4(sp)
    flw    f2,   2 * 4(sp)
    flw    f3,   3 * 4(sp)
    flw    f4,   4 * 4(sp)
    flw    f5,   5 * 4(sp)
    flw    f6,   6 * 4(sp)
    flw    f7,   7 * 4(sp)
    flw    f8,   8 * 4(sp)
    flw    f9,   9 * 4(sp)
    flw    f10, 10 * 4(sp)
    flw    f11, 11 * 4(sp)
    flw    f12, 12 * 4(sp)
    flw    f13, 13 * 4(sp)
    flw    f14, 14 * 4(sp)
    flw    f15, 15 * 4(sp)
    flw    f16, 16 * 4(sp)
    flw    f17, 17 * 4(sp)
    flw    f18, 18 * 4(sp)
    flw    f19, 19 * 4(sp)
    flw    f20, 20 * 4(sp)
    flw    f21, 21 * 4(sp)
    flw    f22, 22 * 4(sp)
    flw    f23, 23 * 4(sp)
    flw    f24, 24 * 4(sp)
    flw    f25, 25 * 4(sp)
    flw    f26, 26 * 4(sp)
    flw    f27, 27 * 4(sp)
    flw    f28, 28 * 4(sp)
    flw    f29, 29 * 4(sp)
    flw    f30, 30 * 4(sp)
    flw    f31, 31 * 4(sp)

    lw     t0,  32 * 4(sp)
    csrw   fcsr, t0

    addi   sp, sp, 4 * 33
#endif

# Retrieve the address at which exception happened
    lw     t0, 0 * 4(sp)
    csrw   mepc, t0

# Pop mstatus from stack and set it
    lw     t0, 29 * 4(sp)
    csrw   mstatus, t0

# Restore x1 to x31 registers
    lw     ra,   1 * 4(sp)
    lw     t0,   2 * 4(sp)
    lw     t1,   3 * 4(sp)
    lw     t2,   4 * 4(sp)
    lw     s0,   5 * 4(sp)
    lw     s1,   6 * 4(sp)
    lw     a0,   7 * 4(sp)
    lw     a1,   8 * 4(sp)
    lw     a2,   9 * 4(sp)
    lw     a3,  10 * 4(sp)
    lw     a4,  11 * 4(sp)
    lw     a5,  12 * 4(sp)
    lw     a6,  13 * 4(sp)
    lw     a7,  14 * 4(sp)
    lw     s2,  15 * 4(sp)
    lw     s3,  16 * 4(sp)
    lw     s4,  17 * 4(sp)
    lw     s5,  18 * 4(sp)
    lw     s6,  19 * 4(sp)
    lw     s7,  20 * 4(sp)
    lw     s8,  21 * 4(sp)
    lw     s9,  22 * 4(sp)
    lw     s10, 23 * 4(sp)
    lw     s11, 24 * 4(sp)
    lw     t3,  25 * 4(sp)
    lw     t4,  26 * 4(sp)
    lw     t5,  27 * 4(sp)
    lw     t6,  28 * 4(sp)

    addi   sp, sp, 4 * 30

# Exception return will restore remaining context
    mret

#*******************************************************************************
#knlIntCtxSw
#int level sw
#********************************************************************************

knlCtxSw:
knlIntCtxSw:
# MIE_MSIE -- enable software interrupt bit
    li     t0, RISCV_MIE_MSIE
    csrrs  zero, mie, t0

# This will trigger a synchronous software interrupt; PRCI->MSIP[0] = 0x01;
    li     t0, RISCV_PRCI_BASE_ADDR
    li     t1, 0x1
    sw     t1, 0x0(t0)
    ret
#*******************************************************************************
