
#ifndef _KNLCONFIG_H
#define _KNLCONFIG_H

#include "device.h"
#include "Task.h"

/*******************************************************************************
the basic data type define 
********************************************************************************/





/*******************************************************************************
the stack grownth direction  
********************************************************************************/
#define DIR_UP 0
#define DIR_DOWN 1
#define STACK_DIRECTION        DIR_DOWN
#define STACK_CHECK_EN   0   // 1: check task stack every second  0: never check task stack
#define PRE_EMPTIVE_EN 1 //0: non pre-emptive     1:pre-emptive

#define M_INT(x) BIT((x) - 1) //x indexs from 1, not 0!!!
#define IERVALUE  (M_INT(1) | M_INT(2) |M_INT(3)| M_INT(4) | M_INT(6)| M_INT(7) | M_INT(8) | M_INT(9)|M_INT(11)| M_INT(13) | M_INT(14))

#define KNL_TOTAL_STK_SIZE		TaskStackSize*cPrioRsvd		/*	total stack size for all tasks		*/
#define KNL_TICKS_PER_SEC        1000    /*    os tick number for 1 second    */

/*******************************************************************************
the used CPU configurtion 
********************************************************************************/
#define PROTECT_EN()        __disable_irq()
#define PROTECT_DIS()       __enable_irq()
#define TASK_SW()           knlCtxSw()


//******************************************************************************
//*                 the  global variable  data type define 
//******************************************************************************
typedef struct
{
    knlStack_t *tcbStackPtr; /*        pointer to stack position    */
    uint16_t timerPeriod; /*        timer period            */
    int32_t targetTime; /*        target time            */
    taskEvent_t eventRx; /*        event received*/
    taskEvent_t eventWait; /*        event waited            */
}knl_tcb_t;
typedef struct
{
    knlStack_t* start;
    knlStack_t* end;
    uint16_t used;
}knl_stack_t;

//******************************************************************************
//*                 the  global variable declarations
//******************************************************************************


#endif

/*****************************end of the Kernel.h ****************************/

