/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * @examplespi external loopback master
 * @brief  
 *   SPI Digital External Loopback.
 *
 *   In this routine, only one SPI is needed. Connect the MISO and MOSI of the SPI
 *   together. The sending and receiving of external loopback test data for a SPI
 *   (without using FIFO and interrupts). After sending a data, the received data
 *   is used for verification, and the test is carried out in a loop (the data
 *   will increment each time the loop is completed).
 * 
 *   Watch Variables:
 *                   - sdata - Data to send
 *                   - rdata - Received data
 *
 * @note:
 *   1.This test routine is designed to verify the basic SPI communication functionality.
 *
 */

/**
 * @examplespi external loopback master
 * @brief  
 *   SPI ⻷ء
 * 
 *   ʱֻҪʹһSPISPIMISOMOSIж̽ӡһSPIⲿز
 *   ݵķգδʹFIFOжϣһݺյУ飬ѭв
 *  ÿһѭ
 *
 *   :
 *           - sdata - ͵
 *           - rdata - յ
 *
 * @note:
 *   1.֤SPIͨŹ
 *
 */

#include "spi_external_loopback_master.h"
#include "device.h"
#include "log.h"

int main(void)
{
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    __disable_irq();
    /** @brief Initialize the SPI version 3.0 (Clock,Pinmux and Function). */
    spi_init();
    __enable_irq();

    spi_process();

    while (1) {

    }

    return 0;
}
