/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * @examplespi external loopback fifo interrupt slave
 * @brief  
 *   SPI is used for communication between the slave device and the host device.
 *
 *   This test routine configures SPIA as the slave mode and prewrites data into
 *   the transmit FIFO, waiting for the host to initiate communication, and then
 *   receives and verifies the data sent by the host.
 * 
 *   Watch Variables:
 *                   - sData[] - Data to send
 *                   - rData[] - Received data
 *
 * @note:
 *   1.This test routine is applicable to chips that only support one SPI interface.
 *   2.This test routine needs to be used in conjunction with 04_spi_external_loopback_fifo_master.
 *     Two eco-boards are required, one acting as the master and the other as the slave.
 *   3.This test routine needs to be run as a slave machine first, and then the
 *     program as the master machine can be run.
 *
 */

/**
 * @examplespi external loopback fifo interrupt slave
 * @brief  
 *   SPI Ϊӻͨ
 * 
 *   ̽SPIAΪģʽǰд뷢FIFOȴͨѶ
 *   ղУ͵ݡ
 *
 *   :
 *           - sData[] - ͵
 *           - rData[] - յ
 *
 * @note:
 *   1.ֻ֧һ·SPIоƬ
 *   2.Ҫ04_spi_external_loopback_fifo_masterһʹãʹ̬壬
 *     һΪһΪӻ
 *   3.ΪӻҪȿʼУȻȥΪĳ
 *
 */

#include "device.h"
#include "log.h"
#include "spi_external_loopback_fifo_slave.h"

int main(void)
{
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    __disable_irq();
    /** @brief Initialize the SPI version 3.0 (Clock,Pinmux and Function). */
    spi_init();
    __enable_irq();

    spi_process();

    while (1) {

    }

    return 0;
}
