/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * @examplespi flash
 * @brief  
 *   SPI read and write external Flash
 *
 *   This test routine implements read and write operations on the W25Q128
 *   external Flash via the SPI interface, including functions such as device
 *   initialization, ID verification, data writing and reading verification.
 *   It uses polling to conduct data transmission, ensuring the correctness of
 *   Flash data reading and writing, and providing a basic verification for SPI
 *   communication with the external Flash.
 *
 *   Watch Variables:
 *                   - sData[128] - Data written to flash
 *                   - rData[128] - Read out the data of flash
 *
 * @note:
 *   1.When using this routine, it is necessary to select and modify the pins
 *     for the SPI and FLASH connection according to different eco-boards.
 *
 */

/**
 * @examplespi flash
 * @brief  
 *   SPIдⲿFlash
 *
 *   ʵͨ SPI ӿڶ W25Q128 ⲿ Flash жд豸ʼ
 *   ID У顢д뼰ȡ֤ȹܣѯʽݴ䣬ȷ Flash ݶд
 *   ȷԣΪ SPI ⲿ Flash ͨṩ֤
 *
 *   :
 *           - sData[128] - дflash
 *           - rData[128] - flash
 *
 * @note:
 *   1.ʹñҪݲ̬ͬѡ޸SPIFLASHӵ
 *
 */

#include "device.h"
#include "log.h"
#include "spi_flash.h"

int main(void)
{
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    __disable_irq();

    /** @brief Initialize the SPI version 3.0 (Clock,Pinmux and Function). */
    spi_init();

    __enable_irq();

    spi_process();

    while (1) {

    }

    return 0;
}
