/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * @example: spi dma flash
 * @brief:
 *   SPI uses DMA to perform read and write operations on the FLASH.
 *
 *   This test routine implements operations on the W25Q128 external Flash through
 *   the SPI interface in conjunction with DMA. It includes functions such as device
 *   initialization, ID verification, sector erasure, data reading and writing,
 *   and verification. By leveraging DMA, it enhances data transmission efficiency
 *   and ensures the correctness and efficiency of Flash operations, This provides
 *   a basic verification for SPI's use of DMA for communication with the external
 *   Flash.
 *
 *   Watch Variables:
 *                   - sData[128] - Data written to flash
 *                   - rData[128] - Read out the data of flash
 *
 * @note:
 *   1.To utilize the DMA function, it is necessary to employ the FIFO mode and
 *     set the FIFO waterline.
 *   2.Avoid setting the transmit FIFO waterline (TXFFIL) to 0h or 10h to ensure
 *     that the DMA configuration is correct.
 *   3.Avoid setting the Receive FIFO Waterline (RXFFIL) to 0h or 1h to ensure
 *     that the DMA configuration is correct.
 *
 */

/**
 * @example: spi dma flash
 * @brief
 *   SPIʹDMAFLASHжд
 *
 *   ʵͨ SPI ӿڽ DMA  W25Q128 ⲿ Flash в豸ʼ
 *   ID У顢ݶд֤ȹܣ DMA ݴЧʣȷ Flash 
 *   ȷЧԣΪ SPI ʹDMAⲿ Flash ͨṩ֤
 *
 *   :
 *           - sData - дflash
 *           - rData - flash
 *
 * @note:
 *   1.ʹDMAܣʹFIFOģʽFIFOˮ;
 *   2.⽫FIFOˮ(TXFFIL)Ϊ 0h  10hȷDMA;
 *   3.⽫FIFOˮ(RXFFIL)Ϊ 0h  1hȷDMA
 *
 */



#include "device.h"
#include "log.h"
#include "spi_dma_flash.h"

int main(void)
{
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    __disable_irq();

    /** @brief Initialize the SPI version 3.0 (Clock,Pinmux and Function). */
    spi_init();

    dma_init();

    __enable_irq();

    spi_process();

    while (1) {

    }

    return 0;
}
