/**
 * @copyright Copyright (c) GeJian Semiconductors 2025. All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ===================================================================================
 */

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
/* ========================================================================== */
/*                           Macro Definitions                                */
/* ========================================================================== */

/**
 * @brief Demo selection macros. Set only one to 1.
 */
#define DEMO_ILM_LOAD_ECC_ERROR         (1)
#define DEMO_ILM_STORE_ECC_ERROR        (0) //by chance ?
//#define DEMO_DLM_LOAD_ECC_ERROR         (0)
//#define DEMO_DLM_STORE_ECC_ERROR        (1)

/* The memory address within ILM to be tested. */
#define ILM_TEST_ADDRESS            (0x10830000)
#define DLM_TEST_ADDRESS            (0x10845000)
volatile uint16_t nmiflag;
volatile uint32_t mecc_code;
volatile uint32_t ramid;
volatile uint32_t sramid;
void user_default_exception_handler(unsigned long mcause, unsigned long sp)
{
	mecc_code = __RV_CSR_READ(CSR_MECC_CODE); // ECC status and injection code

	/* Decode the mecc_code register to identify the error source */
	ramid = (mecc_code >> 16) & 0x1F;   // Reports double-bit errors
	sramid = (mecc_code >> 24) & 0x1F; // Reports single-bit errors
	nmiflag = SysCtl_getNMIFlagStatus();
	while(1);
}

/* ========================================================================== */
/*                         Global Function Definitions                        */
/* ========================================================================== */
int main(void)
{
	/*
	 * @details 这个例程演示了怎么触发ILM DLM的ECC校验错误。
	 *
	 * 		    例程最终进入到用户默认异常处理程序。可观察下面的变量、寄存器、API
	 *
	 * 		    寄存器:$mecc_code,$mecc_status,$milm_ctl,$mdlm_ctl
	 * 		    API:SysCtl_getNMIFlagStatus()
	 * */
    __disable_irq();
     Device_init();

#if DEMO_ILM_LOAD_ECC_ERROR == 1

    __RV_CSR_WRITE(CSR_MECC_CODE, 0x7F);
    __RV_CSR_SET(CSR_MILM_CTL, MILM_CTL_ILM_CHECKECC | MILM_CTL_ILM_RWECC);
    /*
     * 写入动作,写入错误的ecc code
     * */
    *(volatile uint32_t *)ILM_TEST_ADDRESS = 0x12345678;
    /*
     * 读动作,触发硬件进行校验
     * */
    volatile uint32_t read_data = *(volatile uint32_t *)ILM_TEST_ADDRESS;

#elif DEMO_ILM_STORE_ECC_ERROR == 1

    /* --- Phase 1: 埋入错误ECC code --- */
    {
        __RV_CSR_CLEAR(CSR_MILM_CTL, MILM_CTL_ILM_CHECKECC);

        __RV_CSR_WRITE(CSR_MECC_CODE, 0x7F);

        __RV_CSR_SET(CSR_MILM_CTL, MILM_CTL_ILM_RWECC);
        /*
         * 写入动作,写入错误的ecc code
         * */
        *(volatile uint32_t *)ILM_TEST_ADDRESS = 0x12345678;

        __DSB();
        __ISB();
    }

    /* --- Phase 2: 触发Read-Modify-Write --- */
    {
        __RV_CSR_SET(CSR_MILM_CTL, MILM_CTL_ILM_CHECKECC);
        /*
         * 执行部分写的操作。这个会触发硬件去执行Read-Modify-Write,当执行读的这一环节就会检测到ECC错误,
         * 然后因为这个是写操作,所以触发了"Store/AMO access fault" exception
         * */
        *(volatile uint16_t *)ILM_TEST_ADDRESS = 0xAAAA; //Breakpoint here then run mcause 7 mdcause 7 ?
    }

#elif DEMO_DLM_LOAD_ECC_ERROR == 1

    DisableICache();
    DisableDCache();
    __RV_CSR_WRITE(CSR_MECC_CODE, 0x7F);
    __RV_CSR_SET(CSR_MDLM_CTL, MILM_CTL_DLM_CHECKECC | MDLM_CTL_DLM_RWECC);
    /*
     * 写入动作,触发写入错误的ecc code
     * */
    DLM_TEST_VARIABLE = 0x12345678;
    /*
     * 读动作,触发硬件进行校验
     * */
    volatile uint32_t read_data = DLM_TEST_VARIABLE;
#elif DEMO_DLM_STORE_ECC_ERROR == 1
    DisableICache();
    DisableDCache();
    /* --- Phase 1: 埋入错误ECC code --- */
    {
        __RV_CSR_WRITE(CSR_MECC_CODE, 0x7F);

        __RV_CSR_SET(CSR_MDLM_CTL, MDLM_CTL_DLM_RWECC);
        /*
         * 写入动作,触发写入错误的ecc code
         * */
        *(volatile uint32_t *)DLM_TEST_ADDRESS = 0x12345678;
        __DSB();
    }

    /* --- Phase 2: 触发Read-Modify-Write --- */
    {
        /*
         * 执行部分写的操作。这个会触发硬件去执行Read-Modify-Write,当执行读的这一环节就会检测到ECC错误,
         * */
        *(volatile uint16_t*)DLM_TEST_ADDRESS = 0xAAAA; //Breakpoint here then run mcause 7 mdcause 7 ?
    }

#endif
    while (1) {
    }

    return 0;
}

#ifdef __cplusplus
}
#endif
