/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * @example: can_transfer
 * @Language:English
 * @encode:
 * @brief:
 * This routine demonstrates the normal mode of CAN communication.
 * In this process, after receiving the message, the message ID is incremented by 1 and then sent out in the interrupt service function for message transmission and reception.
 * The CAN 2.0 protocol is used. The baud rate is set to 1M and the sampling point is 80%.
 */

/*
 * @example: can_transfer
 * @Language:Chinese
 * @encode:GBK
 * @brief:
 *	ʾCANģʽշ
 *	ڽյĺѱID+1 ٷͳȥ жϷȥշ
 *	ʹCANЭ Ϊ1M 80%
 */

#include "device.h"
#include "can_transfer.h"

int main(void)
{
	Device_init();

	__disable_irq();

	UartPrint_init(LOG_SCI_BASE, 115200);

	GPIO_setPinConfig(CAN_RX_PIN);
	GPIO_setPinConfig(CAN_TX_PIN);

	can_ctrl_init();

	__enable_irq();

	while (1);
}
