/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * @example: scheduled
 * @Language:Chinese
 * @encode:GBK
 * @brief:
 *	ʾCANģѯʱͺͽչܵʹá
 *	ʱ1sһζʱжȥscheduled_can־λ ־λ>0ᴥͺͽ
 *	ѯͱidΪ0xcc ݶ07
 *	ѯձ ѯfifoı״̬ Ϊһֱȡ յıĻid1ͳȥ
 *	ʹCAN2.0Э Ϊ1M 80%
 */

#include "device.h"
#include "log.h"
#include "can_scheduled.h"

volatile uint32_t scheduled_can = 0;

#if USING_VECTOR_INTERRUPT != 0
__INTERRUPT void TIMER1_IRQHandler(void)
{
	SAVE_IRQ_CSR_CONTEXT();

	CPUTimer_clearOverflowFlag(CPUTIMER1_BASE);
	scheduled_can++;

	RESTORE_IRQ_CSR_CONTEXT();
}
#else

void TIMER1_IRQHandler(void)
{
	CPUTimer_clearOverflowFlag(CPUTIMER1_BASE);
	scheduled_can++;
}
#endif

int32_t Timer1_init(uint32_t period)
{
	CPUTimer_init(CPUTIMER1_BASE, period);

	Interrupt_register(INT_TIMER1, TIMER1_IRQHandler);
	Interrupt_enable(INT_TIMER1);

	return 0;
}

int main(void)
{
	Device_init();

	UartPrint_init(LOG_SCI_BASE, 115200);

	Timer1_init(DEVICE_APBCLK_FREQ);

	GPIO_setPinConfig(CAN_RX_PIN);
	GPIO_setPinConfig(CAN_TX_PIN);

	can_ctrl_init();

	__enable_irq();

	while (1)
	{
		if (scheduled_can > 0)
		{
			scheduledreception();
			scheduledsend();
			scheduled_can--;
		}
	}
}
