
/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file   clb_ex1combian_logic.c
*   @brief
*   @details
*
///! The objective of this example is to prevent simultaneous high or low outputs
//! on a PWM pair. PWM modules 1 and 2 are configured to generate identical
//! waveforms based on a fixed frequency up-count mode.
//!
//! See LICENSE for license details.

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "board.h"


/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define EDA_CSIM                  0             //set to 1 when make target for simulation

#if EDA_CSIM != 0
#define LOG_LEVEL                 LOG_ERROR
void _putchar(char character)
{
    //do nothing
}
#else
#define LOG_LEVEL                 LOG_INFO
#endif


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */




int main(void)
{
	 uint32_t oldTicks;

	    __disable_irq();

	    Device_init();
	    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_CLB);


    __enable_irq();

    CLB_init();
// OUTPUT TO IO

    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE ,XBAR_OUTPUT1,XBAR_OUT_MUX00_CLB1_OUT1);
    XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX00);
    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT2,XBAR_OUT_MUX02_CLB1_OUT3);
    XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE ,XBAR_OUTPUT2,XBAR_MUX02);


    XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE ,XBAR_OUTPUT1,XBAR_OUT_MUX01_CLB1_OUT1 );
    XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX01);
    XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,XBAR_OUTPUT2,XBAR_OUT_MUX05_CLB1_OUT3);
    XBAR_enableOutputMux(OUTPUTXBAR_BASE ,XBAR_OUTPUT2,XBAR_MUX05);


    while (1) {

    }

    return 0;
}

