/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    xdma_ex00_m2m_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "stdio.h"
#include "string.h"
#include "xdma_dsp_ex00_m2m_board.h"
#include "device.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define DMA_BUF_SIZE 64

#define DMA_M2M_TEST_FOR_DTCM (0)
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */
#if (XDMAC_VERSION == 0x20)
#if (DMA_M2M_TEST_FOR_DTCM)

__attribute__((aligned(__SCB_DCACHE_LINE_SIZE))) uint32_t Dma_SrcData[DMA_BUF_SIZE] = {0};
__attribute__((aligned(__SCB_DCACHE_LINE_SIZE))) uint32_t Dma_DstData[DMA_BUF_SIZE] = {0};

#else
__IO uint32_t * Dma_SrcData = (volatile uint32_t *)(ITCM_BASE);
__IO uint32_t * Dma_DstData = (volatile uint32_t *)(ITCM_BASE + 0x1000);

#endif /* #if (DMA_M2M_TEST_FOR_DTCM) */

#else

uint32_t Dma_SrcData[DMA_BUF_SIZE] = {0};
uint32_t Dma_DstData[DMA_BUF_SIZE] = {0};

#endif  /* #if (XDMAC_VERSION == 0x20) */
/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
uint32_t reg_data = 0;

/*
 * @brief Configure dma
 * 	DMA Channel number		: DMA1_CH3_BASE
 *  DMA transfer direction  : Memory to Memory
 */
void dma_ex01_m2m(void)
{

	uint32_t errCnt = 0;
    uint32_t i,ret=0;

    XDMA_ConfigParams dmaCfg = {0};

    /* Initialize source test data */
    for(i = 0; i < DMA_BUF_SIZE; i++)
    {
        Dma_SrcData[i] = i + 1;
    }
    memset((void *)Dma_DstData, 0 , DMA_BUF_SIZE);

    /* DMA global enable */
    XDMA_initController(DMA1_BASE);

    /* Stop DMA channel first - why the DMA channel is still pending after reset? */

    dmaCfg.enableInterrupt = 0;
    dmaCfg.srcAddr = (uint32_t)Dma_SrcData;
    dmaCfg.destAddr = (uint32_t)Dma_DstData;
    dmaCfg.blockTS = DMA_BUF_SIZE;
    dmaCfg.ttfc    = XDMA_TT_FC_0_M2M_DMAC;
    dmaCfg.srcBtl  = XDMA_BTL_4;
    dmaCfg.destBtl = XDMA_BTL_4;
    dmaCfg.srcAddrDirect = XDMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = XDMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_4;
    dmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_4;

    XDMA_configChannel(DMA1_CH3_BASE, &dmaCfg);
    XDMA_clearInterrupt(DMA1_CH3_BASE, XDMA_INT_ERR|XDMA_INT_TFR);
    XDMA_unMaskInterrupt(DMA1_CH3_BASE, XDMA_INT_ERR|XDMA_INT_TFR);



    /* DMA channel enable */
    XDMA_startChannel(DMA1_CH3_BASE);

    while((XDMA_getInterruptStatus(DMA1_CH3_BASE) & (XDMA_INT_TFR | XDMA_INT_ERR)) == 0);

#if (XDMAC_VERSION == 0x20)
    /* Very Important No.2, after XDMA TFR DONE, need to flush Cache if use RAM when use cache feature. */
    if (!XDMA_checkRamInAxi2Space(dmaCfg.destAddr, DMA_BUF_SIZE))
    {
    	/*Other RAM need flush the Cache by manual*/
        SCB_InvalidateDCache_by_Addr((volatile void *)(dmaCfg.destAddr), DMA_BUF_SIZE);
    }
#endif

    for(i = 0; i < DMA_BUF_SIZE; i++)
    {
        if(Dma_SrcData[i] != Dma_DstData[i])
        {
            errCnt++;
        }
    }

    if(errCnt == 0)
    {
        printf("DMA M2M block transfer test OK.\r\n");
    }
    else
    {
        printf("DMA M2M block transfer test Fail.\r\n");
    }

    printf("test_dma_ex01_m2m end \r\n");
}

#ifdef __cplusplus
}
#endif

