/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    dma_ex04_CPUTime_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "xdma_dsp_ex02_adc_1ch.h"
#include "printf.h"
#include "device.h"
#include "cpu.h"



volatile uint16_t testdmabuf[4];
volatile uint16_t result=0;

void adc_init(void)
{


	//adc初始?
	ADC_setVREF(ADCA_BASE,ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);

	ADC_setINLTrim(ADCA_BASE);
	//设置分频
	ADC_setPrescaler(ADCA_BASE,ADC_CLK_DIV_4_0);
	//设置中断触发的时机，比如转换前或转换?
	ADC_setInterruptPulseMode(ADCA_BASE,ADC_PULSE_END_OF_CONV);
	//使能转换
	ADC_enableConverter(ADCA_BASE);

	DEVICE_DELAY_US(5000);
	//禁止突发模式，轮询模式的soc会在setupSOC中被配置突发模式
	ADC_disableBurstMode(ADCA_BASE);
	//设置序列优先?
	ADC_setSOCPriority(ADCA_BASE, ADC_PRI_ALL_ROUND_ROBIN);

	//设置soc
	ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER0, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 50U);
	ADC_setInterruptSOCTrigger(ADCA_BASE, ADC_SOC_NUMBER0, ADC_INT_SOC_TRIGGER_NONE);



		//
		// ADC Interrupt 1 Configuration
		// 		Source	: ADC_SOC_NUMBER1
		// 		Interrupt Source: enabled
		// 		Continuous Mode	: enabled
		//
		//

	ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER1, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN1, 50U);
	ADC_setInterruptSOCTrigger(ADCA_BASE, ADC_SOC_NUMBER1, ADC_INT_SOC_TRIGGER_NONE);

	ADC_setInterruptSource(ADCA_BASE, ADC_INT_NUMBER1, ADC_SOC_NUMBER1);
		ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);
		ADC_enableContinuousMode(ADCA_BASE, ADC_INT_NUMBER1);
		ADC_enableInterrupt(ADCA_BASE, ADC_INT_NUMBER1);
		EINT;






	//printf("result=\r\n",result);

}


void DMA_init(void)
{
	uint8_t status=0;
	XDMA_ConfigParams dmacfg={0};
	XDMA_initController(DMA1_BASE);
	XDMA_stopChannel(DMA1_CH1_BASE);
	dmacfg.enableInterrupt = 1;
	dmacfg.destAddr = (uint32_t)(&testdmabuf[0]); /* destination address */
	dmacfg.srcAddr = (uint32_t)(ADCARESULT_BASE); /* source address */
	dmacfg.blockTS = 128; /* block transfer size */
	dmacfg.ttfc = XDMA_TT_FC_2_P2M_DMAC;
	dmacfg.srcBtl = XDMA_BTL_1;
	dmacfg.destBtl = XDMA_BTL_1;
	dmacfg.srcAddrDirect = XDMA_ADDR_NO_CHANGE;
	dmacfg.destAddrDirect = XDMA_ADDR_NO_CHANGE;
	dmacfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_2;
	dmacfg.destTrWidthBytes = XDMA_TR_WIDTH_BYTE_2;

    dmacfg.reloadSrc = true;
    dmacfg.reloadDst = true;
    dmacfg.dmaSrcReqId = DMAMUX_ReqId_Trig_ADCA_1int;

    dmacfg.chPriority = XDMA_CH_PRIORITY_0;


    XDMA_configChannel(DMA1_CH1_BASE,&dmacfg);

	XDMA_clearInterrupt(DMA1_CH1_BASE,XDMA_INT_BLOCK);
	XDMA_unMaskInterrupt(DMA1_CH1_BASE,XDMA_INT_BLOCK);

	XDMA_startChannel(DMA1_CH1_BASE);
	printf("startchan\r\n");
	status=XDMA_getInterruptStatus(DMA1_CH1_BASE);
	printf("status=%d\r\n");




}









void test03_dma_adc_1chn(void)
{

	adc_init();
	DMA_init();

	while(1)
	{

		ADC_forceMultipleSOC(ADCA_BASE, ADC_FORCE_SOC0 | ADC_FORCE_SOC1);
		while(ADC_getInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1) == false)
		{
			//printf("get interruptstatus error\r\n");
		}
		//printf("test03_dma_adc_1chn while \r\n");
		ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);
		result = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER0);
		printf("%d\r\n",result);
		if(XDMA_getInterruptStatus(DMA1_CH1_BASE)==XDMA_INT_BLOCK)
		{
			printf("DMA block transfer is over\r\n");
			XDMA_clearInterrupt(DMA1_CH1_BASE,XDMA_INT_BLOCK);
			break;
		}

	}

	DINT;
	//printf("test over \r\n");

}
















#ifdef __cplusplus
}
#endif

