/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    xdma_dsp_ex02_adc_soc_continuous_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "xdma_dsp_ex02_adc_soc_continue_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

void myADC_init(uint32_t adcBase,ADC_IntNumber intNum){

    /* ADC Initialization: Write ADC configurations and power up the ADC */

    /* Configures the ADC module's offset trim */
#if ((GS32F3xx & 0xFF00) || (GS32F00xx & 0xFF00))   
    ADC_setVREF(adcBase,ADC_REFERENCE_INTERNAL, ADC_REFERENCE_3_3V);
#if !(GS32F3xx & 0x2000)
    ADC_setVCM(adcBase,ADC_VCM_1_65V);        
#endif
#endif    
    ADC_setINLTrim(adcBase);

    /* Configures the analog-to-digital converter module prescaler. */
    ADC_setPrescaler(adcBase, ADC_CLK_DIV_3_0);

    /* Sets the timing of the end-of-conversion pulse */
    ADC_setInterruptPulseMode(adcBase, ADC_PULSE_END_OF_CONV);

    /* Powers up the analog-to-digital converter core. */
    ADC_enableConverter(adcBase);

    /* Delay for 1ms to allow ADC time to power up */
    DEVICE_DELAY_US(5000);

    /* SOC Configuration: Setup ADC EPWM channel and trigger settings */

    /* Disables SOC burst mode. */
    ADC_disableBurstMode(adcBase);

    /* Sets the priority mode of the SOCs. */
    ADC_setSOCPriority(adcBase, ADC_PRI_ALL_ROUND_ROBIN);


    /* @brief  Start of Conversion 0 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 0
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN0
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */

    ADC_setupSOC(adcBase, ADC_SOC_NUMBER0, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER0, ADC_INT_SOC_TRIGGER_NONE);


    /* @brief  Start of Conversion 1 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 1
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN1
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */

    ADC_setupSOC(adcBase, ADC_SOC_NUMBER1, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER1, ADC_INT_SOC_TRIGGER_NONE);


    /* @brief  Start of Conversion 2 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 2
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN2
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */

    ADC_setupSOC(adcBase, ADC_SOC_NUMBER2, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER2, ADC_INT_SOC_TRIGGER_NONE);


    /* @brief  Start of Conversion 3 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 3
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN3
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */

    ADC_setupSOC(adcBase, ADC_SOC_NUMBER3, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER3, ADC_INT_SOC_TRIGGER_NONE);


    /* @brief  Start of Conversion 4 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 4
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN4
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */

    ADC_setupSOC(adcBase, ADC_SOC_NUMBER4, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER4, ADC_INT_SOC_TRIGGER_NONE);


    /* @brief  Start of Conversion 5 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 5
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN5
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */

    ADC_setupSOC(adcBase, ADC_SOC_NUMBER5, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER5, ADC_INT_SOC_TRIGGER_NONE);


    /* @brief  Start of Conversion 6 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 6
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN6
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */

    ADC_setupSOC(adcBase, ADC_SOC_NUMBER6, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER6, ADC_INT_SOC_TRIGGER_NONE);

    /* @brief  Start of Conversion 7 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 7
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN7
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER7, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER7, ADC_INT_SOC_TRIGGER_NONE);

    /* @brief  Start of Conversion 8 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 8
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN8
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER8, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER8, ADC_INT_SOC_TRIGGER_NONE);

    /* @brief  Start of Conversion 9 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 9
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN9
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER9, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER9, ADC_INT_SOC_TRIGGER_NONE);
    /* @brief  Start of Conversion 10 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 10
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN10
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER10, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER10, ADC_INT_SOC_TRIGGER_NONE);

    /* @brief  Start of Conversion 11 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 11
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN11
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER11, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER11, ADC_INT_SOC_TRIGGER_NONE);

    /* @brief  Start of Conversion 12 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 12
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN12
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER12, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER12, ADC_INT_SOC_TRIGGER_NONE);

    /* @brief  Start of Conversion 13 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 13
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN13
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER13, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER13, ADC_INT_SOC_TRIGGER_NONE);

    /* @brief  Start of Conversion 14 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 14
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN14
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER14, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER14, ADC_INT_SOC_TRIGGER_NONE);


    /* @brief  Start of Conversion 15 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC number         : 15
     *      Trigger            : ADC_TRIGGER_SW_ONLY
     *      Channel            : ADC_CH_ADCIN3
     *      Sample Window      : 9 SYSCLK cycles
     *      Interrupt Trigger  : ADC_INT_SOC_TRIGGER_NONE
     */
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER15, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER15, ADC_INT_SOC_TRIGGER_NONE);

    /* @brief ADC Interrupt 1 Configuration
     *       SOC/EOC number    : 0
     *       Interrupt Source  : enabled
     *       Continuous Mode   : enabled
     */
    ADC_setInterruptSource(adcBase, intNum, ADC_SOC_NUMBER15);
    ADC_enableInterrupt(adcBase, intNum);
    ADC_clearInterruptStatus(adcBase, intNum);
    ADC_enableContinuousMode(adcBase, intNum);   

    /* @brief PPB Configuration: Configure high and low limits detection for ADCPPB
     *
     * Post Processing Block 1 Configuration
     * 		 Configures a post-processing block (PPB) in the ADC.
     *       PPB Number                : 1
     *       SOC/EOC number            : 0
     *       Interrupt Sources Enabled : ADC_EVT_TRIPHI,ADC_EVT_TRIPLO
     *       Calibration Offset        : 0
     *       Reference Offset          : 0
     *       Two's Complement          : Disabled
     *       Trip High Limit           : 3000
     *       Trip Low Limit            : 1000
     *       Clear PPB Event Flags     : Disabled
     */

    ADC_setupPPB(adcBase, intNum, ADC_SOC_NUMBER15);
    ADC_enablePPBEvent(adcBase, intNum, (ADC_EVT_TRIPHI | ADC_EVT_TRIPLO | ADC_EVT_ZERO));
    ADC_enablePPBEventInterrupt(adcBase, intNum, (ADC_EVT_TRIPHI | ADC_EVT_TRIPLO));
    ADC_disablePPBEventInterrupt(adcBase, intNum, (ADC_EVT_ZERO));
    ADC_setPPBCalibrationOffset(adcBase, intNum, 0);
    ADC_setPPBReferenceOffset(adcBase, intNum, 0);
    ADC_disablePPBTwosComplement(adcBase, intNum);
    ADC_setPPBTripLimits(adcBase, intNum, 3000, 1000);
    ADC_disablePPBEventCBCClear(adcBase, intNum);    
}


void myADC_PbEvtinit(uint32_t adcBase){
	/* Set ADC AnaSysctrl */
#if ((GS32F3xx & 0xFF) == 0x0)     
    ADC_setVREF(adcBase,ADC_REFERENCE_EXTERNAL, ADC_REFERENCE_3_3V);
#endif    
    ADC_setINLTrim(adcBase);
    /* Configures the analog-to-digital converter module prescaler. */
    ADC_setPrescaler(adcBase, ADC_CLK_DIV_5_0);
    /* Sets the timing of the end-of-conversion pulse */
    ADC_setInterruptPulseMode(adcBase, ADC_PULSE_END_OF_CONV);
    /* Powers up the analog-to-digital converter core. */
    ADC_enableConverter(adcBase);
    /* Delay for 1ms to allow ADC time to power up */
    DEVICE_DELAY_US(5000);
    /* SOC Configuration: Setup ADC EPWM channel and trigger settings  */
    /* Disables SOC burst mode.*/
    ADC_disableBurstMode(adcBase);
    /*Sets the priority mode of the SOCs.*/
    ADC_setSOCPriority(adcBase, ADC_PRI_ALL_ROUND_ROBIN);

    /* @brief Start of Conversion 0 Configuration
     *
     * Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
     *      SOC/EOC number    : 0
     *      Trigger           : ADC_TRIGGER_EPWM1_SOCA
     *      Channel           : ADC_CH_ADCIN0
     *      Sample Window     : 9 SYSCLK cycles
     *      Two's Complement  : Disabled
     *      Interrupt Trigger : ADC_INT_SOC_TRIGGER_NONE
     */
    ADC_setupSOC(adcBase, ADC_SOC_NUMBER0, ADC_TRIGGER_EPWM1_SOCA, ADC_CH_ADCIN0, 9U);
    ADC_setInterruptSOCTrigger(adcBase, ADC_SOC_NUMBER0, ADC_INT_SOC_TRIGGER_NONE);

    /* @brief ADC Interrupt 1 Configuration
     *       SOC/EOC number    : 0
     *       Interrupt Source  : enabled
     *       Continuous Mode   : disabled
     */
    ADC_setInterruptSource(adcBase, ADC_INT_NUMBER1, ADC_SOC_NUMBER0);
    ADC_enableInterrupt(adcBase, ADC_INT_NUMBER1);
    ADC_clearInterruptStatus(adcBase, ADC_INT_NUMBER1);
    ADC_disableContinuousMode(adcBase, ADC_INT_NUMBER1);
            
    /* @brief PPB Configuration: Configure high and low limits detection for ADCPPB
     *
     * Post Processing Block 1 Configuration
     * Configures a post-processing block (PPB) in the ADC.
     *       PPB Number                : 1
     *       SOC/EOC number            : 0
     *       Interrupt Sources Enabled : ADC_EVT_TRIPHI,ADC_EVT_TRIPLO
     *       Calibration Offset        : 0
     *       Reference Offset          : 0
     *       Two's Complement          : Disabled
     *       Trip High Limit           : 3000
     *       Trip Low Limit            : 1000
     *       Clear PPB Event Flags     : Disabled
     */
    ADC_setupPPB(adcBase, ADC_PPB_NUMBER1, ADC_SOC_NUMBER0);
    ADC_enablePPBEvent(adcBase, ADC_PPB_NUMBER1, (ADC_EVT_TRIPHI | ADC_EVT_TRIPLO | ADC_EVT_ZERO));
    ADC_enablePPBEventInterrupt(adcBase, ADC_PPB_NUMBER1, (ADC_EVT_TRIPHI | ADC_EVT_TRIPLO));
    ADC_disablePPBEventInterrupt(adcBase, ADC_PPB_NUMBER1, (ADC_EVT_ZERO));
    ADC_setPPBCalibrationOffset(adcBase, ADC_PPB_NUMBER1, 0);
    ADC_setPPBReferenceOffset(adcBase, ADC_PPB_NUMBER1, 0);
    ADC_disablePPBTwosComplement(adcBase, ADC_PPB_NUMBER1);
    ADC_setPPBTripLimits(adcBase, ADC_PPB_NUMBER1, 3000, 1000);
    ADC_disablePPBEventCBCClear(adcBase, ADC_PPB_NUMBER1);
}



//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
    EALLOW;

    myADC_init(testADC_BASE,    testADC_INT_NUMBER);
    //myADC_PbEvtinit(testADC_BASE);

    EDIS;
}

#ifdef __cplusplus

#endif

