/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    xdma_dsp_ex06_spi.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include <stdio.h>
#include "device.h"
#include "xdma_dsp_ex06_spi_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

uint16_t SPI_TXBUF[DMA_BUF_SIZE];
uint16_t SPI_RXBUF[DMA_BUF_SIZE];


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */


/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */


/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */



/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */



/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

 int main(void)
{


#if ((GS32F3xx & 0xFF00) || (GS32F00xx & 0xFF00))
    //
    // Initialize device clock and peripherals
    //
    Device_init();
#endif
    volatile uint16_t sData = 0;
    volatile uint16_t rData = 0;
    volatile uint8_t ret;

    UartPrint_init(LOG_SCI_BASE, 115200);
    __enable_irq();
    board_init();


    for(int i=0;i<32;i++)
    {
    	SPI_TXBUF[i]=i;
    	SPI_RXBUF[i]=0;
    }


    XDMA_startChannel(DMA1_CH1_BASE);
    XDMA_startChannel(DMA1_CH2_BASE);
    printf("DMA start\r\n");
    while(XDMA_getInterruptStatus(DMA1_CH2_BASE) == 0){
    }
    printf("tfr\r\n");

    while(1) {}
}


 void spiRxFIFOISR(void)
 {
 	// Gets the interrupt flag bit
     uint32_t status = SPI_getInterruptStatus(mySPI_BASE);
     //If FIFO is error
     if((status & SPI_ISR_TXOIS) \
     		||(status & SPI_ISR_RXUIS)\
     		||(status & SPI_ISR_RXOIS))
     {
     	SPI_disableInterrupt(mySPI_BASE,status);
     	//ESTOP0;
     }

     SPI_clearAllInterruptStatus(mySPI_BASE);
 }

 void INT_mySPI0_TX_DMA_ISR(void)
 {
 	uint16_t i;
     XDMA_stopChannel(DMA1_CH1_BASE);
 	XDMA_clearInterrupt(DMA1_CH1_BASE, XDMA_INT_TFR);
 	__DSB();
 }

 void INT_mySPI0_RX_DMA_ISR(void)
 {
     uint16_t i;

     XDMA_stopChannel(DMA1_CH2_BASE);

     //
     // Check for data integrity
     //
 	XDMA_clearInterrupt(DMA1_CH2_BASE, XDMA_INT_TFR);
     for(i = 0; i < 32; i++)
     {
         if (SPI_RXBUF[i] != i)
         {
             // Something went wrong. rData doesn't contain expected data.
             //ESTOP0;
             printf("error\r\n");
         }
     }
     __DSB();
 }




#ifdef __cplusplus
}
#endif
/*****END OF FILE****/

