/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    ecap_ex03_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "ecap_ex03_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define CAP_CH            5

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

#define CounterResetOnEvent 1
#define ECAP_ECCTL2_SYNCI_EN_BIT 1
/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

// Board Configurations
void Board_init()
{
	PinMux_init();
	INPUTXBAR_init();
    ECAP_init();
	GPIO_init();
	INTERRUPT_init();
}

// PINMUX Configurations
void PinMux_init()
{

	GPIO_setPinConfig(mYGPIO_2_GPIO2);
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(2, GPIO_QUAL_SYNC);
    //
	// PinMux for modules assigned to CPU1
	//

	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setLoopBack(myEPWM1_EPWMA_GPIO, 1);

	GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);
	//GPIO 8
	GPIO_setPinConfig(GPIO_24_OUTPUTXBAR1);


}

// ECAP Configurations
void ECAP_init()
{
    myECAP0_init();
}

// ECAP1
void myECAP0_init()
{

	//
	// Disable ,clear all capture flags and interrupts
	//
	ECAP_disableInterrupt(myECAP1_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
	ECAP_clearInterrupt(myECAP1_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));

	// Disables time stamp capture.

	ECAP_disableTimeStampCapture(myECAP1_BASE);

	// Stops Time stamp counter.

	ECAP_stopCounter(myECAP1_BASE);

	// Sets eCAP in Capture mode.

	ECAP_enableCaptureMode(myECAP1_BASE);

	// Sets the capture mode.

	ECAP_setCaptureMode(myECAP1_BASE,ECAP_ONE_SHOT_CAPTURE_MODE,ECAP_EVENT_4);

	// Sets the Capture event prescaler.

	ECAP_setEventPrescaler(myECAP1_BASE, 0U);

	// Sets the Capture event polarity.

	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_1,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_2,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_3,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_4,ECAP_EVENT_RISING_EDGE);

	// Configure counter reset on events

	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_1);
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_2);
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_3);
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_4);

	// Select eCAP input.

	ECAP_selectECAPInput(myECAP1_BASE,ECAP_INPUT_OUTPUTXBAR1);

	// Sets a phase shift value count.

	ECAP_setPhaseShiftCount(myECAP1_BASE,0U);

	// Enable counter loading with phase shift value.

	ECAP_disableLoadCounter(myECAP1_BASE);

	// Configures Sync out signal mode.

	ECAP_setSyncOutMode(myECAP1_BASE,ECAP_SYNC_OUT_SYNCI);

	// Configures emulation mode.

	ECAP_setEmulationMode(myECAP1_BASE,ECAP_EMULATION_STOP);

	// Set up the source for sync-in pulse..

//	SysCtl_setECAPSyncInPulseSource(myECAP1_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1);

	// Starts Time stamp counter for myECAP0.

	ECAP_startCounter(myECAP1_BASE);

	// Enables time stamp capture for myECAP0.

	ECAP_enableTimeStampCapture(myECAP1_BASE);

	// Re-arms the eCAP module for myECAP0.

	ECAP_reArm(myECAP1_BASE);

	// Enables interrupt source for myECAP0.

	ECAP_enableInterrupt(myECAP1_BASE,ECAP_ISR_SOURCE_CAPTURE_EVENT_4);

	ECAP_setDBFilterCfg(myECAP1_BASE,0x03);
}

// GPIO Configurations
void GPIO_init()
{
	myGPIO0_init();
}

// GPIO Configurations for ECAP1
void myGPIO0_init()
{
	// EPWM_1A connects GPIO0 by default.
}

// INPUTXBAR Configurations
void INPUTXBAR_init()
{
	myINPUTXBARINPUT0_init();
}

// OUTPUTXBAR Configurations for ECAP1 output
void myINPUTXBARINPUT0_init()
{
//	CLB_configOutputLUT(CLB1_BASE, CLB_OUT0, 0X550018);
//	CLB_enableCLB(CLB1_BASE);

	XBAR_setInputPin(INPUTXBAR_BASE,myINPUTXBARINPUT0_INPUT, myINPUTXBARINPUT0_SOURCE);
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,XBAR_OUTPUT1, XBAR_OUT_MUX17_INPUTXBAR7 );
	XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT1, XBAR_MUX17);
}

// INTERRUPT Configurations
void INTERRUPT_init()
{
	Interrupt_SetPriorityGrouping(0);
  	Interrupt_SetPriority(INT_myECAP0,0,0);
	Interrupt_register(INT_myECAP0,Ecap_ex03_IrqHandler);
  	Interrupt_enable(INT_myECAP0);
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

