/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    ecap_ex08_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "ecap_ex08_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

// Board Configurations
void Board_init()
{
	GPIO_init();
	INPUTXBAR_init();
    ECAP_init();
    INTERRUPT_init();
}

// GPIO Configurations
void GPIO_init()
{
	myGPIO0_init();
}

// GPIO Configurations for GPIO
void myGPIO0_init()
{
	GPIO_setPinConfig(myGPIO_EPWM1_A);
	GPIO_setPadConfig(0, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(0, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(0,1);

	GPIO_setPinConfig(myGPIO_EPWM1_B);
	GPIO_setPadConfig(1, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(1, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(1,1);

	GPIO_setPinConfig(myGPIO_EPWM2_A);
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(2, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(2,1);

	GPIO_setPinConfig(myGPIO_EPWM2_B);
	GPIO_setPadConfig(3, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(3, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(3,1);

	GPIO_setPinConfig(myGPIO_EPWM3_A);
	GPIO_setPadConfig(4, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(4, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(4,1);

	GPIO_setPinConfig(myGPIO_EPWM3_B);
	GPIO_setPadConfig(5, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(5, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(5,1);
}

// ECAP Configurations
void ECAP_init()
{
    myECAP0_init();
}

// ECAP1~6
void myECAP0_init()
{
	//
	// Disable ,clear all capture flags and interrupts
	//
	ECAP_disableInterrupt(myECAP1_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
	ECAP_clearInterrupt(myECAP1_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));

	ECAP_disableInterrupt(myECAP2_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
	ECAP_clearInterrupt(myECAP2_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));

	ECAP_disableInterrupt(myECAP3_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
	ECAP_clearInterrupt(myECAP3_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));

	ECAP_disableInterrupt(myECAP4_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
	ECAP_clearInterrupt(myECAP4_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));

	ECAP_disableInterrupt(myECAP5_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
	ECAP_clearInterrupt(myECAP5_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));

	ECAP_disableInterrupt(myECAP6_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
	ECAP_clearInterrupt(myECAP6_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));

	// Disables time stamp capture.

	ECAP_disableTimeStampCapture(myECAP1_BASE);
	ECAP_disableTimeStampCapture(myECAP2_BASE);
	ECAP_disableTimeStampCapture(myECAP3_BASE);
	ECAP_disableTimeStampCapture(myECAP4_BASE);
	ECAP_disableTimeStampCapture(myECAP5_BASE);
	ECAP_disableTimeStampCapture(myECAP6_BASE);

	// Stops Time stamp counter.

	ECAP_stopCounter(myECAP1_BASE);
	ECAP_stopCounter(myECAP2_BASE);
	ECAP_stopCounter(myECAP3_BASE);
	ECAP_stopCounter(myECAP4_BASE);
	ECAP_stopCounter(myECAP5_BASE);
	ECAP_stopCounter(myECAP6_BASE);

	// Sets eCAP in Capture mode.

	ECAP_enableCaptureMode(myECAP1_BASE);
	ECAP_enableCaptureMode(myECAP2_BASE);
	ECAP_enableCaptureMode(myECAP3_BASE);
	ECAP_enableCaptureMode(myECAP4_BASE);
	ECAP_enableCaptureMode(myECAP5_BASE);
	ECAP_enableCaptureMode(myECAP6_BASE);

	// Sets the capture mode.

	ECAP_setCaptureMode(myECAP1_BASE,ECAP_ONE_SHOT_CAPTURE_MODE,ECAP_EVENT_4);
	ECAP_setCaptureMode(myECAP2_BASE,ECAP_ONE_SHOT_CAPTURE_MODE,ECAP_EVENT_4);
	ECAP_setCaptureMode(myECAP3_BASE,ECAP_ONE_SHOT_CAPTURE_MODE,ECAP_EVENT_4);
	ECAP_setCaptureMode(myECAP4_BASE,ECAP_ONE_SHOT_CAPTURE_MODE,ECAP_EVENT_4);
	ECAP_setCaptureMode(myECAP5_BASE,ECAP_ONE_SHOT_CAPTURE_MODE,ECAP_EVENT_4);
	ECAP_setCaptureMode(myECAP6_BASE,ECAP_ONE_SHOT_CAPTURE_MODE,ECAP_EVENT_4);

	// Sets the Capture event prescaler.

	ECAP_setEventPrescaler(myECAP1_BASE, 0U);
	ECAP_setEventPrescaler(myECAP2_BASE, 0U);
	ECAP_setEventPrescaler(myECAP3_BASE, 0U);
	ECAP_setEventPrescaler(myECAP4_BASE, 0U);
	ECAP_setEventPrescaler(myECAP5_BASE, 0U);
	ECAP_setEventPrescaler(myECAP6_BASE, 0U);

	// Sets the Capture event polarity.

	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_1,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_2,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_3,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_4,ECAP_EVENT_FALLING_EDGE);

	ECAP_setEventPolarity(myECAP2_BASE,ECAP_EVENT_1,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP2_BASE,ECAP_EVENT_2,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP2_BASE,ECAP_EVENT_3,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP2_BASE,ECAP_EVENT_4,ECAP_EVENT_FALLING_EDGE);

	ECAP_setEventPolarity(myECAP3_BASE,ECAP_EVENT_1,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP3_BASE,ECAP_EVENT_2,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP3_BASE,ECAP_EVENT_3,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP3_BASE,ECAP_EVENT_4,ECAP_EVENT_FALLING_EDGE);

	ECAP_setEventPolarity(myECAP4_BASE,ECAP_EVENT_1,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP4_BASE,ECAP_EVENT_2,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP4_BASE,ECAP_EVENT_3,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP4_BASE,ECAP_EVENT_4,ECAP_EVENT_FALLING_EDGE);

	ECAP_setEventPolarity(myECAP5_BASE,ECAP_EVENT_1,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP5_BASE,ECAP_EVENT_2,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP5_BASE,ECAP_EVENT_3,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP5_BASE,ECAP_EVENT_4,ECAP_EVENT_FALLING_EDGE);

	ECAP_setEventPolarity(myECAP6_BASE,ECAP_EVENT_1,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP6_BASE,ECAP_EVENT_2,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP6_BASE,ECAP_EVENT_3,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP6_BASE,ECAP_EVENT_4,ECAP_EVENT_FALLING_EDGE);

	// Configure counter reset on events

	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_1);
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_2);
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_3);
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_4);

	ECAP_enableCounterResetOnEvent(myECAP2_BASE,ECAP_EVENT_1);
	ECAP_enableCounterResetOnEvent(myECAP2_BASE,ECAP_EVENT_2);
	ECAP_enableCounterResetOnEvent(myECAP2_BASE,ECAP_EVENT_3);
	ECAP_enableCounterResetOnEvent(myECAP2_BASE,ECAP_EVENT_4);

	ECAP_enableCounterResetOnEvent(myECAP3_BASE,ECAP_EVENT_1);
	ECAP_enableCounterResetOnEvent(myECAP3_BASE,ECAP_EVENT_2);
	ECAP_enableCounterResetOnEvent(myECAP3_BASE,ECAP_EVENT_3);
	ECAP_enableCounterResetOnEvent(myECAP3_BASE,ECAP_EVENT_4);

	ECAP_enableCounterResetOnEvent(myECAP4_BASE,ECAP_EVENT_1);
	ECAP_enableCounterResetOnEvent(myECAP4_BASE,ECAP_EVENT_2);
	ECAP_enableCounterResetOnEvent(myECAP4_BASE,ECAP_EVENT_3);
	ECAP_enableCounterResetOnEvent(myECAP4_BASE,ECAP_EVENT_4);

	ECAP_enableCounterResetOnEvent(myECAP5_BASE,ECAP_EVENT_1);
	ECAP_enableCounterResetOnEvent(myECAP5_BASE,ECAP_EVENT_2);
	ECAP_enableCounterResetOnEvent(myECAP5_BASE,ECAP_EVENT_3);
	ECAP_enableCounterResetOnEvent(myECAP5_BASE,ECAP_EVENT_4);

	ECAP_enableCounterResetOnEvent(myECAP6_BASE,ECAP_EVENT_1);
	ECAP_enableCounterResetOnEvent(myECAP6_BASE,ECAP_EVENT_2);
	ECAP_enableCounterResetOnEvent(myECAP6_BASE,ECAP_EVENT_3);
	ECAP_enableCounterResetOnEvent(myECAP6_BASE,ECAP_EVENT_4);

	// Select eCAP input.

	ECAP_selectECAPInput(myECAP1_BASE,ECAP_INPUT_INPUTXBAR1);
	ECAP_selectECAPInput(myECAP2_BASE,ECAP_INPUT_INPUTXBAR2);
	ECAP_selectECAPInput(myECAP3_BASE,ECAP_INPUT_INPUTXBAR3);
	ECAP_selectECAPInput(myECAP4_BASE,ECAP_INPUT_INPUTXBAR4);
	ECAP_selectECAPInput(myECAP5_BASE,ECAP_INPUT_INPUTXBAR5);
	ECAP_selectECAPInput(myECAP6_BASE,ECAP_INPUT_INPUTXBAR6);

	// Sets a phase shift value count.

	ECAP_setPhaseShiftCount(myECAP1_BASE,0U);
	ECAP_setPhaseShiftCount(myECAP2_BASE,0U);
	ECAP_setPhaseShiftCount(myECAP3_BASE,0U);
	ECAP_setPhaseShiftCount(myECAP4_BASE,0U);
	ECAP_setPhaseShiftCount(myECAP5_BASE,0U);
	ECAP_setPhaseShiftCount(myECAP6_BASE,0U);

	// Enable counter loading with phase shift value.

	ECAP_enableLoadCounter(myECAP1_BASE);
	ECAP_enableLoadCounter(myECAP2_BASE);
	ECAP_enableLoadCounter(myECAP3_BASE);
	ECAP_enableLoadCounter(myECAP4_BASE);
	ECAP_enableLoadCounter(myECAP5_BASE);
	ECAP_enableLoadCounter(myECAP6_BASE);

	// Configures Sync out signal mode.

	ECAP_setSyncOutMode(myECAP1_BASE,ECAP_SYNC_OUT_DISABLED);
	ECAP_setSyncOutMode(myECAP2_BASE,ECAP_SYNC_OUT_DISABLED);
	ECAP_setSyncOutMode(myECAP3_BASE,ECAP_SYNC_OUT_DISABLED);
	ECAP_setSyncOutMode(myECAP4_BASE,ECAP_SYNC_OUT_DISABLED);
	ECAP_setSyncOutMode(myECAP5_BASE,ECAP_SYNC_OUT_DISABLED);
	ECAP_setSyncOutMode(myECAP6_BASE,ECAP_SYNC_OUT_DISABLED);

	// Configures emulation mode.

	ECAP_setEmulationMode(myECAP1_BASE,ECAP_EMULATION_STOP);
	ECAP_setEmulationMode(myECAP2_BASE,ECAP_EMULATION_STOP);
	ECAP_setEmulationMode(myECAP3_BASE,ECAP_EMULATION_STOP);
	ECAP_setEmulationMode(myECAP4_BASE,ECAP_EMULATION_STOP);
	ECAP_setEmulationMode(myECAP5_BASE,ECAP_EMULATION_STOP);
	ECAP_setEmulationMode(myECAP6_BASE,ECAP_EMULATION_STOP);

	// Set up the source for sync-in pulse..

	ECAP_setSyncInPulseSource(myECAP1_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM1);
	ECAP_setSyncInPulseSource(myECAP2_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM1);
	ECAP_setSyncInPulseSource(myECAP3_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM2);
	ECAP_setSyncInPulseSource(myECAP4_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM2);
	ECAP_setSyncInPulseSource(myECAP5_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM3);
	ECAP_setSyncInPulseSource(myECAP6_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM3);

	// Starts Time stamp counter for myECAP1~6.

	ECAP_startCounter(myECAP1_BASE);
	ECAP_startCounter(myECAP2_BASE);
	ECAP_startCounter(myECAP3_BASE);
	ECAP_startCounter(myECAP4_BASE);
	ECAP_startCounter(myECAP5_BASE);
	ECAP_startCounter(myECAP6_BASE);

	// Enables time stamp capture for myECAP1~6.

	ECAP_enableTimeStampCapture(myECAP1_BASE);
	ECAP_enableTimeStampCapture(myECAP2_BASE);
	ECAP_enableTimeStampCapture(myECAP3_BASE);
	ECAP_enableTimeStampCapture(myECAP4_BASE);
	ECAP_enableTimeStampCapture(myECAP5_BASE);
	ECAP_enableTimeStampCapture(myECAP6_BASE);

	// Re-arms the eCAP module for myECAP1~6.

	ECAP_reArm(myECAP1_BASE);
	ECAP_reArm(myECAP2_BASE);
	ECAP_reArm(myECAP3_BASE);
	ECAP_reArm(myECAP4_BASE);
	ECAP_reArm(myECAP5_BASE);
	ECAP_reArm(myECAP6_BASE);

	// enable Interrupts

//	ECAP_enableInterrupt(myECAP1_BASE,ECAP_ISR_SOURCE_CAPTURE_EVENT_4);
//	ECAP_enableInterrupt(myECAP2_BASE,ECAP_ISR_SOURCE_CAPTURE_EVENT_4);
//	ECAP_enableInterrupt(myECAP3_BASE,ECAP_ISR_SOURCE_CAPTURE_EVENT_4);
//	ECAP_enableInterrupt(myECAP4_BASE,ECAP_ISR_SOURCE_CAPTURE_EVENT_4);
//	ECAP_enableInterrupt(myECAP5_BASE,ECAP_ISR_SOURCE_CAPTURE_EVENT_4);
//	ECAP_enableInterrupt(myECAP6_BASE,ECAP_ISR_SOURCE_CAPTURE_EVENT_4);

	// Enables debounce Filter for myECAP1~6.

	ECAP_setDBFilterCfg(myECAP1_BASE,0x03);
	ECAP_setDBFilterCfg(myECAP2_BASE,0x03);
	ECAP_setDBFilterCfg(myECAP3_BASE,0x03);
	ECAP_setDBFilterCfg(myECAP4_BASE,0x03);
	ECAP_setDBFilterCfg(myECAP5_BASE,0x03);
	ECAP_setDBFilterCfg(myECAP6_BASE,0x03);

}

// INPUTXBAR Configurations
void INPUTXBAR_init()
{
	myINPUTXBARINPUT0_init();
}

// OUTPUTXBAR Configurations for ECAP1 output
void myINPUTXBARINPUT0_init()
{
	XBAR_setInputPin(INPUTXBAR_BASE,myINPUTXBAR_INPUT1, myINPUTXBAR1_GPIO_SOURCE);
	XBAR_setInputPin(INPUTXBAR_BASE,myINPUTXBAR_INPUT2, myINPUTXBAR2_GPIO_SOURCE);
	XBAR_setInputPin(INPUTXBAR_BASE,myINPUTXBAR_INPUT3, myINPUTXBAR3_GPIO_SOURCE);
	XBAR_setInputPin(INPUTXBAR_BASE,myINPUTXBAR_INPUT4, myINPUTXBAR4_GPIO_SOURCE);
	XBAR_setInputPin(INPUTXBAR_BASE,myINPUTXBAR_INPUT5, myINPUTXBAR5_GPIO_SOURCE);
	XBAR_setInputPin(INPUTXBAR_BASE,myINPUTXBAR_INPUT6, myINPUTXBAR6_GPIO_SOURCE);
}

void INTERRUPT_init()
{
//	Interrupt_SetPriorityGrouping(0);
//	Interrupt_SetPriority(myEPWM1_BASE,0,0);
//	Interrupt_SetPriority(myEPWM2_BASE,0,0);
//	Interrupt_SetPriority(myEPWM3_BASE,0,0);
	Interrupt_register(INT_EPWM1,Ecap_ex08_IrqHandler1);
	Interrupt_register(INT_EPWM2,Ecap_ex08_IrqHandler2);
	Interrupt_register(INT_EPWM3,Ecap_ex08_IrqHandler3);
	Interrupt_enable(INT_EPWM1);
	Interrupt_enable(INT_EPWM2);
	Interrupt_enable(INT_EPWM3);
	EINT; // __enable_irq();
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

