/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    board.h
*   @brief   
*
*/

#ifndef DEVICE_BOARD_H_
#define DEVICE_BOARD_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

//
// EPWM1 -> EPWM1 Pinmux
//
//
// EPWM1_A - GPIO Settings
//
#define GPIO_PIN_EPWM1_A 0
#define EPWM1_EPWMA_GPIO 0
#define EPWM1_EPWMA_PIN_CONFIG  GPIO_0_EPWM1A
//
// EPWM1_B - GPIO Settings
//
#define GPIO_PIN_EPWM1_B 1
#define EPWM1_EPWMB_GPIO 1
#define EPWM1_EPWMB_PIN_CONFIG  GPIO_1_EPWM1B

//
// EPWM2 -> EPWM2 Pinmux
//
//
// EPWM2_A - GPIO Settings
//
#define GPIO_PIN_EPWM2_A 2
#define EPWM2_EPWMA_GPIO 2
#define EPWM2_EPWMA_PIN_CONFIG  GPIO_2_EPWM2A
//
// EPWM2_B - GPIO Settings
//
#define GPIO_PIN_EPWM2_B 3
#define EPWM2_EPWMB_GPIO 3
#define EPWM2_EPWMB_PIN_CONFIG  GPIO_3_EPWM2B

//
// EPWM3 -> EPWM3 Pinmux
//
//
// EPWM3_A - GPIO Settings
//
#define GPIO_PIN_EPWM3_A 4
#define EPWM3_EPWMA_GPIO 4
#define EPWM3_EPWMA_PIN_CONFIG GPIO_4_EPWM3A
//
// EPWM3_B - GPIO Settings
//
#define GPIO_PIN_EPWM3_B 5
#define EPWM3_EPWMB_GPIO 5
#define EPWM3_EPWMB_PIN_CONFIG GPIO_5_EPWM3B

//
// EPWM4 -> EPWM4 Pinmux
//
//
// EPWM4_A - GPIO Settings
//
#define GPIO_PIN_EPWM4_A 6
#define EPWM4_EPWMA_GPIO 6
#define EPWM4_EPWMA_PIN_CONFIG GPIO_6_EPWM4A
//
// EPWM4_B - GPIO Settings
//
#define GPIO_PIN_EPWM4_B 7
#define EPWM4_EPWMB_GPIO 7
#define EPWM4_EPWMB_PIN_CONFIG GPIO_7_EPWM4B

//
// EPWM5 -> EPWM5 Pinmux
//
//
// EPWM5_A - GPIO Settings
//
#define GPIO_PIN_EPWM5_A 8
#define EPWM5_EPWMA_GPIO 8
#define EPWM5_EPWMA_PIN_CONFIG GPIO_8_EPWM5A
//
// EPWM5_B - GPIO Settings
//
#define GPIO_PIN_EPWM5_B 9
#define EPWM5_EPWMB_GPIO 9
#define EPWM5_EPWMB_PIN_CONFIG GPIO_9_EPWM5B



//
// EPWM6 -> EPWM6 Pinmux
//
//
// EPWM6_A - GPIO Settings
//
#define GPIO_PIN_EPWM6_A 10
#define EPWM6_EPWMA_GPIO 10
#define EPWM6_EPWMA_PIN_CONFIG GPIO_10_EPWM6A
//
// EPWM6_B - GPIO Settings
//
#define GPIO_PIN_EPWM6_B 11
#define EPWM6_EPWMB_GPIO 11
#define EPWM6_EPWMB_PIN_CONFIG GPIO_11_EPWM6B

//
// EPWM7 -> EPWM7 Pinmux
//
//
// EPWM7_A - GPIO Settings
//
#define GPIO_PIN_EPWM7_A 12
#define EPWM7_EPWMA_GPIO 12
#define EPWM7_EPWMA_PIN_CONFIG GPIO_12_EPWM7A
//
// EPWM7_B - GPIO Settings
//
#define GPIO_PIN_EPWM7_B 13
#define EPWM7_EPWMB_GPIO 13
#define EPWM7_EPWMB_PIN_CONFIG GPIO_13_EPWM7_B

//
// EPWM8 -> EPWM8 Pinmux
//
//
// EPWM8_A - GPIO Settings
//
#define GPIO_PIN_EPWM8_A 14
#define EPWM8_EPWMA_GPIO 14
#define EPWM8_EPWMA_PIN_CONFIG GPIO_14_EPWM8A
//
// EPWM8_B - GPIO Settings
//
#define GPIO_PIN_EPWM8_B 15
#define EPWM8_EPWMB_GPIO 15
#define EPWM8_EPWMB_PIN_CONFIG GPIO_15_EPWM8B

//
// EPWM9 -> EPWM9 Pinmux
//
//
// EPWM9_A - GPIO Settings
//
#define GPIO_PIN_EPWM9_A 16
#define EPWM9_EPWMA_GPIO 16
#define EPWM9_EPWMA_PIN_CONFIG GPIO_16_EPWM9A
//
// EPWM9_B - GPIO Settings
//
#define GPIO_PIN_EPWM9_B 17
#define EPWM9_EPWMB_GPIO 17
#define EPWM9_EPWMB_PIN_CONFIG GPIO_17_EPWM9B

//
// EPWM10 -> EPWM9 Pinmux
//
//
// EPWM10_A - GPIO Settings
//
#define GPIO_PIN_EPWM10_A 18
#define EPWM10_EPWMA_GPIO 18
#define EPWM10_EPWMA_PIN_CONFIG GPIO_18_EPWM10A
//
// EPWM10_B - GPIO Settings
//
#define GPIO_PIN_EPWM10_B 19
#define EPWM10_EPWMB_GPIO 19
#define EPWM10_EPWMB_PIN_CONFIG GPIO_19_EPWM10B

//
// EPWM11 -> EPWM9 Pinmux
//
//
// EPWM11_A - GPIO Settings
//
#define GPIO_PIN_EPWM11_A 20
#define EPWM11_EPWMA_GPIO 20
#define EPWM11_EPWMA_PIN_CONFIG GPIO_20_EPWM11A
//
// EPWM11_B - GPIO Settings
//
#define GPIO_PIN_EPWM11_B 21
#define EPWM11_EPWMB_GPIO 21
#define EPWM11_EPWMB_PIN_CONFIG GPIO_21_EPWM11B

//
// EPWM12 -> EPWM9 Pinmux
//
//
// EPWM12_A - GPIO Settings
//
#define GPIO_PIN_EPWM12_A 22
#define EPWM12_EPWMA_GPIO 22
#define EPWM12_EPWMA_PIN_CONFIG GPIO_22_EPWM12A
//
// EPWM12_B - GPIO Settings
//
#define GPIO_PIN_EPWM12_B 23
#define EPWM12_EPWMB_GPIO 23
#define EPWM12_EPWMB_PIN_CONFIG GPIO_23_EPWM12B

//
// EPWM13 -> EPWM9 Pinmux
//
//
// EPWM13_A - GPIO Settings
//
#define GPIO_PIN_EPWM13_A 24
#define EPWM13_EPWMA_GPIO 24
#define EPWM13_EPWMA_PIN_CONFIG GPIO_24_EPWM13_A
//
// EPWM13_B - GPIO Settings
//
#define GPIO_PIN_EPWM13_B 25
#define EPWM13_EPWMB_GPIO 25
#define EPWM13_EPWMB_PIN_CONFIG GPIO_25_EPWM13_B

//
// EPWM14 -> EPWM9 Pinmux
//
//
// EPWM14_A - GPIO Settings
//
#define GPIO_PIN_EPWM14_A 26
#define EPWM14_EPWMA_GPIO 26
#define EPWM14_EPWMA_PIN_CONFIG GPIO_26_EPWM14_A
//
// EPWM14_B - GPIO Settings
//
#define GPIO_PIN_EPWM14_B 27
#define EPWM14_EPWMB_GPIO 27
#define EPWM14_EPWMB_PIN_CONFIG GPIO_27_EPWM14_B

//
// EPWM15 -> EPWM9 Pinmux
//
//
// EPWM15_A - GPIO Settings
//
#define GPIO_PIN_EPWM15_A 28
#define EPWM15_EPWMA_GPIO 28
#define EPWM15_EPWMA_PIN_CONFIG GPIO_28_EPWM15_A
//
// EPWM15_B - GPIO Settings
//
#define GPIO_PIN_EPWM15_B 29
#define EPWM15_EPWMB_GPIO 29
#define EPWM15_EPWMB_PIN_CONFIG GPIO_29_EPWM15_B

//
// EPWM16 -> EPWM9 Pinmux
//
//
// EPWM16_A - GPIO Settings
//
#define GPIO_PIN_EPWM16_A 30
#define EPWM16_EPWMA_GPIO 30
#define EPWM16_EPWMA_PIN_CONFIG GPIO_30_EPWM16_A
//
// EPWM16_B - GPIO Settings
//
#define GPIO_PIN_EPWM16_B 31
#define EPWM16_EPWMB_GPIO 31
#define EPWM16_EPWMB_PIN_CONFIG GPIO_31_EPWM16_B

//
// EPWM17 -> EPWM9 Pinmux
//
//
// EPWM17_A - GPIO Settings
//
#define GPIO_PIN_EPWM17_A 67
#define EPWM17_EPWMA_GPIO 67
#define EPWM17_EPWMA_PIN_CONFIG GPIO_67_EPWM17_A
//
// EPWM17_B - GPIO Settings
//
#define GPIO_PIN_EPWM17_B 68
#define EPWM17_EPWMB_GPIO 68
#define EPWM17_EPWMB_PIN_CONFIG GPIO_68_EPWM17_B

//
// EPWM18 -> EPWM9 Pinmux
//
//
// EPWM18_A - GPIO Settings
//
#define GPIO_PIN_EPWM18_A 37
#define EPWM18_EPWMA_GPIO 37
#define EPWM18_EPWMA_PIN_CONFIG GPIO_37_EPWM18_A
//
// EPWM18_B - GPIO Settings
//
#define GPIO_PIN_EPWM18_B 38
#define EPWM18_EPWMB_GPIO 38
#define EPWM18_EPWMB_PIN_CONFIG GPIO_38_EPWM18_B

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************

#define EPWM1_TBPRD 0
#define EPWM1_COUNTER_MODE EPWM_COUNTER_MODE_STOP_FREEZE
#define EPWM1_TBPHS 0
#define EPWM1_CMPA 0
#define EPWM1_CMPB 0
#define EPWM1_CMPC 0
#define EPWM1_CMPD 0
#define EPWM1_DBRED 0
#define EPWM1_DBFED 0
#define EPWM1_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define EPWM1_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define EPWM1_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED

#define EPWM2_TBPRD 0
#define EPWM2_COUNTER_MODE EPWM_COUNTER_MODE_STOP_FREEZE
#define EPWM2_TBPHS 0
#define EPWM2_CMPA 0
#define EPWM2_CMPB 0
#define EPWM2_CMPC 0
#define EPWM2_CMPD 0
#define EPWM2_DBRED 0
#define EPWM2_DBFED 0
#define EPWM2_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define EPWM2_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define EPWM2_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED

#define EPWM3_TBPRD 0
#define EPWM3_COUNTER_MODE EPWM_COUNTER_MODE_STOP_FREEZE
#define EPWM3_TBPHS 0
#define EPWM3_CMPA 0
#define EPWM3_CMPB 0
#define EPWM3_CMPC 0
#define EPWM3_CMPD 0
#define EPWM3_DBRED 0
#define EPWM3_DBFED 0
#define EPWM3_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define EPWM3_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define EPWM3_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED


#define EPWM4_TBPRD 20
#define EPWM4_COUNTER_MODE EPWM_COUNTER_MODE_UP_DOWN
#define EPWM4_TBPHS 0
#define EPWM4_CMPA 10
#define EPWM4_CMPB 10
#define EPWM4_CMPC 0
#define EPWM4_CMPD 0
#define EPWM4_DBRED 0
#define EPWM4_DBFED 0
#define EPWM4_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define EPWM4_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define EPWM4_INTERRUPT_SOURCE EPWM_INT_TBCTR_DISABLED






#define PWMA_CMP		0
#define PWMB_CMP		0
//ʱ
#define DB_delay		0.15
//Сռձ
#define Min_duty		0.2

#define UPDOWM			0

#if (UPDOWM == 1)
#define PWM_PRD         (DEVICE_SYSCLK_FREQ/50000/2)

#else
#define PWM_PRD         (DEVICE_SYSCLK_FREQ/50000-1)
#endif
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */



/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */




/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */




/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void Board_init();
void PinMux_init();



void InitEPWMModule(uint32_t base, uint32_t period);

void EPWM_MinDB_updateDutyUp(uint32_t base,float32_t duty,uint32_t period);
void EPWM_MinDB_updateDutyUpDown(uint32_t base,float32_t duty,uint32_t period);

void InitTimerModule(uint32_t period);


void TIMER1_IRQHandler(void);


#ifdef __cplusplus
}
#endif


#endif /* DEVICE_HEADER_TEMPLATE_H_ */
