/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "epwm_ex16_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */




/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */



/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	EALLOW;

	PinMux_init();
	EPWM_init(EPWM1_BASE);
	GPIO_init();
}


//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{ 
	//
	// PinMux for modules assigned to CPU1
	//
	
	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_3_GPIO3);
	GPIO_setPadConfig(3, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(3, GPIO_QUAL_SYNC);
}

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM_init(uint32_t base){
	HRPWM_setClockPrescaler(base, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	EPWM_setTimeBasePeriod(base, 99);
	HRPWM_setTimeBaseCounter(base, 0);
	HRPWM_setTimeBaseCounterMode(base, EPWM_COUNTER_MODE_UP);
	EPWM_disablePhaseShiftLoad(base);
	EPWM_setPhaseShift(base, 0);
	EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, 50);
	HRPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
	EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, 50);
	HRPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);

	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_LOAD_ON_CNTR_ZERO);
	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_LOAD_ON_CNTR_ZERO);
	//debugͣʱPWM
	EPWM_setEmulationMode(base, 2);


	//չTrip16ź
	XBAR_setEPWMMuxConfig(XBAR_TRIP16, XBAR_EPWM_MUX03_INPUTXBAR2);
	XBAR_enableEPWMMux(XBAR_TRIP16, XBAR_MUX03);
	//ͨTrip12ź
	XBAR_setEPWMMuxConfig(XBAR_TRIP29, XBAR_EPWM_MUX03_INPUTXBAR2);
	XBAR_enableEPWMMux(XBAR_TRIP29, XBAR_MUX03);


	EPWM_selectDigitalCompareTripInput(EPWM1_BASE,EPWM_DC_TRIP_TRIPIN16,EPWM_DC_TYPE_DCAH);
	EPWM_selectDigitalCompareTripInput(EPWM1_BASE,EPWM_DC_TRIP_TRIPIN29,EPWM_DC_TYPE_DCAL);

	/*!!!ע˴enableԭеTrip1~15DCxxЧֻõչTrip DCxxЧ*/
	EPWM_enableDigitalCompareTripInput_Extend(EPWM1_BASE, EPWM_DC_TYPE_DCAH, DCInput_Extend1);
	EPWM_enableDigitalCompareTripInput_Extend(EPWM1_BASE, EPWM_DC_TYPE_DCAL, DCInput_Extend2);

	EPWM_setTripZoneDigitalCompareEventCondition(EPWM1_BASE,EPWM_TZ_DC_OUTPUT_A1,EPWM_TZ_EVENT_DCXH_HIGH);
	EPWM_setTripZoneDigitalCompareEventCondition(EPWM1_BASE,EPWM_TZ_DC_OUTPUT_A2,EPWM_TZ_EVENT_DCXL_HIGH);
	EPWM_enableTripZoneSignals(EPWM1_BASE,EPWM_TZ_SIGNAL_DCAEVT1);
	EPWM_enableTripZoneSignals(EPWM1_BASE,EPWM_TZ_SIGNAL_DCAEVT2);
	EPWM_setTripZoneAction(EPWM1_BASE,EPWM_TZ_ACTION_EVENT_TZA,EPWM_TZ_ACTION_LOW);
	EPWM_setTripZoneAction(EPWM1_BASE,EPWM_TZ_ACTION_EVENT_TZB,EPWM_TZ_ACTION_HIGH);

}


void GPIO_init(void)
{
	GPIO_setDirectionMode(3, GPIO_DIR_MODE_OUT);
	GPIO_setLoopBack(3, TRUE);
	GPIO_WritePin(3, 1);
	XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT2, 3);
}



#ifdef __cplusplus

#endif

