/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    bsp_sram.h
*   @brief
*
*/

#ifndef __BSP_SRAM_H__
#define __BSP_SRAM_H__


//
// Included Files
//
#include "driverlib.h"
#include "device.h"
#include "fsmc.h"

#define SRAM_BASE_ADDR                (FSMC_BANK1_BASE + FSMC_Bank1_NORSRAM1 * 0x4000000)
#define SRAM_SIZE                     (64 * 4) //64 x 4 Bytes
#define SRAM_END_ADDR                 (SRAM_BASE_ADDR + SRAM_SIZE)

//
// Address signal pins
//
#define FSMC_A0_GPIO_PIN            20
#define FSMC_A0_GPIO_PIN_CFG        GPIO_20_FSMC_A0

#define FSMC_A1_GPIO_PIN            21
#define FSMC_A1_GPIO_PIN_CFG        GPIO_21_FSMC_A1

#define FSMC_A2_GPIO_PIN            38
#define FSMC_A2_GPIO_PIN_CFG        GPIO_38_FSMC_A2

#define FSMC_A3_GPIO_PIN            39
#define FSMC_A3_GPIO_PIN_CFG        GPIO_39_FSMC_A3

#define FSMC_A4_GPIO_PIN            40
#define FSMC_A4_GPIO_PIN_CFG        GPIO_40_FSMC_A4

#define FSMC_A5_GPIO_PIN            41
#define FSMC_A5_GPIO_PIN_CFG        GPIO_41_FSMC_A5

#define FSMC_A6_GPIO_PIN            44
#define FSMC_A6_GPIO_PIN_CFG        GPIO_44_FSMC_A6

#define FSMC_A7_GPIO_PIN            45
#define FSMC_A7_GPIO_PIN_CFG        GPIO_45_FSMC_A7

#define FSMC_A8_GPIO_PIN            46
#define FSMC_A8_GPIO_PIN_CFG        GPIO_46_FSMC_A8

#define FSMC_A9_GPIO_PIN            47
#define FSMC_A9_GPIO_PIN_CFG        GPIO_47_FSMC_A9

#define FSMC_A10_GPIO_PIN           48
#define FSMC_A10_GPIO_PIN_CFG       GPIO_48_FSMC_A10

#define FSMC_A11_GPIO_PIN           49
#define FSMC_A11_GPIO_PIN_CFG       GPIO_49_FSMC_A11

#define FSMC_A12_GPIO_PIN           50
#define FSMC_A12_GPIO_PIN_CFG       GPIO_50_FSMC_A12

#define FSMC_A13_GPIO_PIN           51
#define FSMC_A13_GPIO_PIN_CFG       GPIO_51_FSMC_A13

#define FSMC_A14_GPIO_PIN           52
#define FSMC_A14_GPIO_PIN_CFG       GPIO_52_FSMC_A14

#define FSMC_A15_GPIO_PIN           86
#define FSMC_A15_GPIO_PIN_CFG       GPIO_86_FSMC_A15

#define FSMC_A16_GPIO_PIN           87
#define FSMC_A16_GPIO_PIN_CFG       GPIO_87_FSMC_A16

#define FSMC_A17_GPIO_PIN           88
#define FSMC_A17_GPIO_PIN_CFG       GPIO_88_FSMC_A17

#define FSMC_A18_GPIO_PIN           89
#define FSMC_A18_GPIO_PIN_CFG       GPIO_89_FSMC_A18

#define FSMC_A19_GPIO_PIN           90
#define FSMC_A19_GPIO_PIN_CFG       GPIO_90_FSMC_A19

#define FSMC_A20_GPIO_PIN           91
#define FSMC_A20_GPIO_PIN_CFG       GPIO_91_FSMC_A20

#define FSMC_A21_GPIO_PIN           92
#define FSMC_A21_GPIO_PIN_CFG       GPIO_92_FSMC_A21

#define FSMC_A22_GPIO_PIN
#define FSMC_A23_GPIO_PIN
#define FSMC_A24_GPIO_PIN
#define FSMC_A25_GPIO_PIN


//
// Data signal pins
//
#define FSMC_D0_GPIO_PIN            85
#define FSMC_D0_GPIO_PIN_CFG        GPIO_85_FSMC_D0

#define FSMC_D1_GPIO_PIN            83
#define FSMC_D1_GPIO_PIN_CFG        GPIO_83_FSMC_D1

#define FSMC_D2_GPIO_PIN            82
#define FSMC_D2_GPIO_PIN_CFG        GPIO_82_FSMC_D2

#define FSMC_D3_GPIO_PIN            81
#define FSMC_D3_GPIO_PIN_CFG        GPIO_81_FSMC_D3

#define FSMC_D4_GPIO_PIN            80
#define FSMC_D4_GPIO_PIN_CFG        GPIO_80_FSMC_D4

#define FSMC_D5_GPIO_PIN            79
#define FSMC_D5_GPIO_PIN_CFG        GPIO_79_FSMC_D5

#define FSMC_D6_GPIO_PIN            78
#define FSMC_D6_GPIO_PIN_CFG        GPIO_78_FSMC_D6

#define FSMC_D7_GPIO_PIN            77
#define FSMC_D7_GPIO_PIN_CFG        GPIO_77_FSMC_D7

#define FSMC_D8_GPIO_PIN            76
#define FSMC_D8_GPIO_PIN_CFG        GPIO_76_FSMC_D8

#define FSMC_D9_GPIO_PIN            75
#define FSMC_D9_GPIO_PIN_CFG        GPIO_75_FSMC_D9

#define FSMC_D10_GPIO_PIN           74
#define FSMC_D10_GPIO_PIN_CFG       GPIO_74_FSMC_D10

#define FSMC_D11_GPIO_PIN           73
#define FSMC_D11_GPIO_PIN_CFG       GPIO_73_FSMC_D11

#define FSMC_D12_GPIO_PIN           72
#define FSMC_D12_GPIO_PIN_CFG       GPIO_72_FSMC_D12

#define FSMC_D13_GPIO_PIN           71
#define FSMC_D13_GPIO_PIN_CFG       GPIO_71_FSMC_D13

#define FSMC_D14_GPIO_PIN           70
#define FSMC_D14_GPIO_PIN_CFG       GPIO_70_FSMC_D14

#define FSMC_D15_GPIO_PIN           69
#define FSMC_D15_GPIO_PIN_CFG       GPIO_69_FSMC_D15

//
// Control signal lines
// CS (Chip Select)
// NBL1, corresponding base address 0x68000000
// NBL1, corresponding base address 0x68000000
#define FSMC_CS1_GPIO_PIN               13
#define FSMC_CS1_GPIO_PIN_CFG           GPIO_13_FSMC_NE1

#define FSMC_CS2_GPIO_PIN               34
#define FSMC_CS2_GPIO_PIN_CFG           GPIO_34_FSMC_NE2

#define FSMC_CS3_GPIO_PIN               35
#define FSMC_CS3_GPIO_PIN_CFG           GPIO_35_FSMC_NE3

//#define FSMC_CS4_GPIO_PIN               30
//#define FSMC_CS4_GPIO_PIN_CFG           GPIO_30_FSMC_NE4

// WE (Write Enable)
#define FSMC_WE_GPIO_PIN                31
#define FSMC_WE_GPIO_PIN_CFG            GPIO_31_FSMC_RNW

// OE (Output Enable)
#define FSMC_OE_GPIO_PIN                37//32
#define FSMC_OE_GPIO_PIN_CFG            GPIO_37_FSMC_NOE//GPIO_32_FSMC_NOE

// LB (Lower Byte) data mask
#define FSMC_UDQM_GPIO_PIN              6
#define FSMC_UDQM_GPIO_PIN_CFG          GPIO_6_FSMC_NBL0

// UB (Upper Byte) data mask
#define FSMC_LDQM_GPIO_PIN              7
#define FSMC_LDQM_GPIO_PIN_CFG          GPIO_7_FSMC_NBL1


// SRAM initialization
void SRAM_GPIO_Config();
void FSMC_Config();
void SRAM_Init(void);

#endif /* __BSP_SRAM_H__ */

