/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "hrpwm_ex03_board.h"
#include "cpu.h"
#include "epwm.h"
#include "hrpwm.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


#define   EPWM_MODE_SEL    EPWM_MODE_SPWM_0

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

#include "SFO_v2.h"

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

#define temp_duty 0.0001	//0.1%
#define	PWM1_PRD	999
extern float32_t PWM1_duty;

SFO_Params_t SFO_ParamsStruct;
uint16_t status;
/* None */
/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	EALLOW;

	PinMux_init();
	EPWM_init();
	//1msһ
	InitTimerModule(DEVICE_APBCLK_FREQ/100);
	EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);
	GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

}


//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM_init(){

	//PWM1A ߾
	EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;//¼ģʽ
	EPwm1Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;//TBCLK = EPWMCLK / (HSPCLKDIV x CLKDIV).
	EPwm1Regs.TBCTL.bit.CLKDIV = TB_DIV1;
	EPwm1Regs.TBPRD = PWM1_PRD;
	EPwm1Regs.CMPA.bit.CMPA = 0;
	EPwm1Regs.AQCTLA.bit.CAU = AQ_CLEAR;
	EPwm1Regs.AQCTLA.bit.ZRO = AQ_SET;
	EPwm1Regs.AQCTLB.bit.CAU = AQ_CLEAR;
	EPwm1Regs.AQCTLB.bit.ZRO = AQ_SET;

	//ǷԶģʽ
	if(AUTO == 1){
		EPwm1Regs.HRCNFG.bit.AUTOCONV = 1;
	}
	else if(AUTO == 0){
		EPwm1Regs.HRCNFG.bit.AUTOCONV = 0;
	}
	EPwm1Regs.HRCNFG.bit.EDGMODE = HR_FEP;
	EPwm1Regs.HRCNFG.bit.CTLMODE = HR_CMP;
	//ʹУ׼
	EPwm1Regs.HRPWR.bit.CALPWRON = 1;


	/*--SFO ṹ0--*/
	SFO_Struct_deinit(&SFO_ParamsStruct);
	/*--SFO ṹ帳ֵloop_cntƼ4~5--*/
	SFO_Struct_init(&SFO_ParamsStruct,5);

}



void InitTimerModule(uint32_t period)
{
	/* Initialize CPUTimer with interrupt enable */
	CPUTimer_init(CPUTIMER1_BASE, period);
	Interrupt_register(INT_TIMER1, TIMER1_IRQHandler);
	Interrupt_enable(INT_TIMER1);
	Interrupt_SetPriority( INT_TIMER1,  1,  0);
}

void error()
{
	/**/
}

//	1msһ
__interrupt void TIMER1_IRQHandler(void)
{

	status = SFO(&SFO_ParamsStruct);
	//һУ׼
    if (status !=0)
    {
    	error();
    }


	//duty
	if(PWM1_duty < 0.8){
		PWM1_duty += temp_duty;}
	else{
		PWM1_duty = 0;}

	//duty CMPֺС
	if(AUTO){
		EPwm1Regs.CMPA.all = PWM1_duty*(PWM1_PRD+1)*65536;
	}
	else{

		//
		uint32_t duty_i = (uint32_t)(PWM1_duty*(PWM1_PRD+1));
		//С
		float32_t duty_f = PWM1_duty*(PWM1_PRD+1) - duty_i;

		EPwm1Regs.CMPA.bit.CMPA = duty_i;
		EPwm1Regs.CMPA.bit.CMPAHR = (uint16_t)(duty_f * SFO_ParamsStruct.HR_mstep + 0.5) << 9;


		uint16_t temp_i;
		temp_i = ( (EPwm1Regs.CMPA.bit.CMPAHR>>9) / (float32_t)SFO_ParamsStruct.HR_mstep) / 0.25;
		if(( (EPwm1Regs.CMPA.bit.CMPAHR>>9) / (float32_t)SFO_ParamsStruct.HR_mstep) < 0.25)
		{
			EPwm1ExtRegs.HRPWM_INT.bit.CMPAHR_INT = 0;
		}
		else if(( (EPwm1Regs.CMPA.bit.CMPAHR>>9) / (float32_t)SFO_ParamsStruct.HR_mstep) < 0.5)
		{
			EPwm1ExtRegs.HRPWM_INT.bit.CMPAHR_INT = 1;
		}
		else if(( (EPwm1Regs.CMPA.bit.CMPAHR>>9) / (float32_t)SFO_ParamsStruct.HR_mstep) < 0.75)
		{
			EPwm1ExtRegs.HRPWM_INT.bit.CMPAHR_INT = 2;
		}
		else
		{
			EPwm1ExtRegs.HRPWM_INT.bit.CMPAHR_INT = 3;
		}

	}

	CpuTimer1Regs.TIMERINTCLR.bit.TIMECLEARINTER = 1;
}





#ifdef __cplusplus

#endif

