/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */



#ifdef __cplusplus
extern "C"{
#endif


#include "device.h"
#include "eeprom_state.h"


int main(void)
{
	uint16_t error;
	uint16_t i;
    Device_init();

    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_I2C);

    SysCtl_resetI2c();

    UartPrint_init(SCIA_BASE, 115200);
    I2C_GPIO_init();
    I2Cinit(I2C_BASE);
    printf("i2c_ex07_eeprom_state start\r\n");
    //
	// Loop indefinitely
	//
	while(1)
	{
		//
		// **** Write data to EEPROM section ****
		//
		// Check the outgoing message to see if it should be sent. In this
		// example it is initialized to send with a stop bit.
		//
		if(i2cMsgOut.msgStatus == MSG_STATUS_SEND_WITHSTOP)
		{
			//
			// Send the data to the EEPROM
			//
			error = writeData(&i2cMsgOut);
			//
			// If communication is correctly initiated, set msg status to busy
			// and update currentMsgPtr for the interrupt service routine.
			// Otherwise, do nothing and try again next loop. Once message is
			// initiated, the I2C interrupts will handle the rest. See the
			// function i2cAISR().
			//
			if(error == SUCCESS)
			{
				currentMsgPtr = &i2cMsgOut;
				i2cMsgOut.msgStatus = MSG_STATUS_WRITE_BUSY;
			}
		}

		//
		// **** Read data from EEPROM section ****
		//
		// Check outgoing message status. Bypass read section if status is
		// not inactive.
		//
		if (i2cMsgOut.msgStatus == MSG_STATUS_INACTIVE)
		{
			//
			// Check incoming message status
			//
			if(i2cMsgIn.msgStatus == MSG_STATUS_SEND_NOSTOP)
			{
				//
				// Send EEPROM address setup
				//
				readData(&i2cMsgIn);

			  //
			  // Update current message pointer and message status
			  //
			  currentMsgPtr = &i2cMsgIn;
			  i2cMsgIn.msgStatus = MSG_STATUS_SEND_NOSTOP_BUSY;
		   }

			//
			// Once message has progressed past setting up the internal address
			// of the EEPROM, send a restart to read the data bytes from the
			// EEPROM. Complete the communique with a stop bit. msgStatus is
			// updated in the interrupt service routine.
			//
			else if(i2cMsgIn.msgStatus == MSG_STATUS_RESTART)
			{

				//
				// Update current message pointer and message status
				//
				currentMsgPtr = &i2cMsgIn;
				i2cMsgIn.msgStatus = MSG_STATUS_READ_BUSY;
			}
		}
		Check_Status();
	}
}




#ifdef __cplusplus
}
#endif

