/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "device.h"
#include "driverlib.h"
#include "load_img.h"
#include "log.h"            //smp thread safe
#include "board_cfg.h"

#define CORE_LED_PIN             LED1_PIN

__SHARED_BSS__ volatile uint32_t cpu1Ticks;
__SHARED_BSS__ volatile uint32_t cpu2Ticks;

extern void Shared_show(void);

__attribute__((interrupt)) void TIMER0_IRQHandler(void)
{
    //SAVE_FPU_CONTEXT();

    //float a[32];

    CPUTimer_clearOverflowFlag(CPUTIMER0_BASE);
    cpu1Ticks++;

//    a[0] = (float)cpu1Ticks;
//    a[1] = a[0] + 1.0;
//    a[2] = a[0] + 2.0;
//    a[3] = a[0] + 3.0;
//    a[5] = a[0] + 4.0;
//    a[5] = a[0] + 5.0;
//    a[6] = a[0] + 6.0;
//    a[7] = a[0] + 7.0;
//    a[8] = a[0] + 8.0;
//    a[9] = a[0] + 9.0;
//    a[10] = a[0] + 10.0;
//    a[11] = a[0] + 11.0;
//    a[12] = a[0] + 12.0;
//    a[13] = a[0] + 13.0;
//    a[14] = a[0] + 14.0;
//    a[15] = a[0] + 15.0;
//    a[16] = a[0] + 16.0;
//    a[17] = a[0] + 17.0;
//    a[18] = a[0] + 18.0;
//    a[19] = a[0] + 19.0;
//    a[20] = a[0] + 20.0;
//    a[21] = a[0] + 21.0;
//
//    a[21] = a[0] + a[1] + a[2] + a[3] + a[4] + a[5] + a[6] + a[7] + a[8] + a[9] +
//            a[10] + a[11] + a[12] + a[13] + a[14] + a[15] + a[16] + a[17] + a[18] + a[19] + a[20];
//    cpu1Ticks = a[21];

    //RESTORE_FPU_CONTEXT();
}

void Timer_init(void)
{
    CPUTimer_init(CPUTIMER0_BASE, DEVICE_APBCLK_FREQ/100);  //10ms

    Interrupt_register(INT_TIMER0, TIMER0_IRQHandler);
    ECLIC_SetShvIRQ(INT_TIMER0, ECLIC_VECTOR_INTERRUPT);
    Interrupt_enable(INT_TIMER0);
}

/* Private functions ---------------------------------------------------------*/
/**
  * @brief
  * @param  None
  * @retval None
  */
int main(void)
{
    uint32_t oldTicks;

    __disable_irq();

    Device_init();

    GPIO_enableWritePin(CORE_LED_PIN);

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    log_info("Hello DSP300 Dualcore Template Project!\r\n");
    log_info("Core%d running @ %d MHz\r\n", __get_hart_id(), DEVICE_SYSCLK_FREQ/1000/1000);
    log_info("Code @ 0x%08X, Data @ 0x%08X\r\n", (uint32_t)main, (uint32_t)&oldTicks);
    log_info("%d Cores, %d IRQn\r\n", CIDU_GetCoreNum(), CIDU_GetIntNum());

    bringup_cpu2();

    Timer_init();

    __enable_irq();

    oldTicks = cpu1Ticks;

    while (1) {
        if (cpu1Ticks != oldTicks) {
            oldTicks = cpu1Ticks;

            if ((oldTicks % 100) == 0) {
                log_debug("cpu1Ticks: %d cpu2Ticks: %d\r\n", cpu1Ticks, cpu2Ticks);
                Shared_show();

                GPIO_togglePin(CORE_LED_PIN);      //not thread safe
            }
        }
    }

    for(;;);

    return 0;
}


