/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "load_img.h"
#include "log.h"            //smp thread safe
#include "board_cfg.h"
#include "interrupt.h"

int main(void)
{
	// 初始?
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);


	//配置GPIO0为输出模?
	GPIO_setDirectionMode(0,GPIO_DIR_MODE_OUT);

    GPIO_setPinConfig(GPIO_1_GPIO1);

    GPIO_setPinConfig(GPIO_2_OUTPUTXBAR1);

    XBAR_setInputPin(INPUTXBAR_BASE,XBAR_INPUT1,1);
    XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX01);
    XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_OUT_MUX01_INPUTXBAR1);

    XBAR_invertOutputSignal(OUTPUTXBAR_BASE, XBAR_OUTPUT1, 0);

    while(1)
    {
        GPIO_writePin(0,1);
        DEVICE_DELAY_US(10000);
        GPIO_writePin(0,0);
        DEVICE_DELAY_US(10000);
    }

    return 0;
}


