/*
 * 07_i2c_state.h
 *
 *  Created on: 2025 Mar 27
 *      Author: hpec
 */

#ifndef __I2C_STATE_H_
#define __I2C_STATE_H_

#include "device.h"

#define I2CA_SDA_PIN 0U
#define I2CA_SCL_PIN 1U

#define I2CA_SDA_PINMUX	GPIO_0_I2CA_SDA
#define I2CA_SCL_PINMUX	GPIO_1_I2CA_SCL

#define I2C_BASE 	I2CA_BASE
#define I2C_REGS 	I2caRegs

typedef enum
{
	I2C_READY = 0,
	I2C_START,
	I2C_TRANSFER,
	I2C_STOP
}I2C_Stage;

void i2c_init(void);
uint8_t i2c_read_data(uint8_t dev_addr,uint16_t reg_addr,uint8_t *pdata,uint16_t datalen);
uint8_t i2c_write_data(uint8_t dev_addr,uint16_t reg_addr,uint8_t *pdata,uint16_t datalen);


#endif
