/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    cmpss_ex4_board.h
*   @brief   
*
*/

#ifndef ECAP_EX03_CAPTURE_PWM_H_
#define ECAP_EX03_CAPTURE_PWM_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "xbar.h"
#include "regs_cmpss.h"
#include "regs_epwm.h"


/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

#define myOUTPUTXBAR0 XBAR_OUTPUT3
#define myOUTPUTXBAR0_ENABLED_MUXES (XBAR_MUX00)

//
// OUTPUTXBAR3 -> myOUTPUTXBAR0 Pinmux
//
//
// OUTPUTXBAR3 - GPIO Settings
//
#define GPIO_PIN_OUTPUTXBAR3 4
#define myOUTPUTXBAR0_OUTPUTXBAR_GPIO 4
#define myOUTPUTXBAR0_OUTPUTXBAR_PIN_CONFIG GPIO_4_OUTPUTXBAR3
#define myPREEPWM  PREEPWM_BASE
#define HRPWM_0CFG_VALUE 0x81F1CB83
#define HRPWM_1CFG_VALUE 0x703
//*****************************************************************************
//
// CMPSS Configurations
//
//*****************************************************************************
#define myCMPSS1_BASE CMPSS1_BASE
#define myCMPSS1_HIGH_COMP_BASE CMPSS1_BASE
#define myCMPSS1_LOW_COMP_BASE CMPSS1_BASE
//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
#define myEPWM1_BASE EPWM1_BASE
#define myEPWM2_BASE EPWM2_BASE
#define myEPWM3_BASE EPWM3_BASE
#define myEPWM4_BASE EPWM4_BASE
#define myEPWM7_BASE EPWM7_BASE

#define PWM1_TIMER_PERIOD 0x9000
#define PWM_CMP_VAL       0x8000
#define PWM_CMP_VBL       0x7FFF

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

//*****************************************************************************
//
// OUTPUTXBAR Configurations
//
//*****************************************************************************
void myOUTPUTXBAR0_init();


//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void	Board_init();
void	CMPSS_init();
void	OUTPUTXBAR_init();
void	PinMux_init();
void    initEPWM();
void    myCMPSS0_init();
/**
 * \brief   "Executable function for ecap capturing pwm signals" 
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void ecap_ex03_capture_pwm(void);

#ifdef __cplusplus
}
#endif


#endif /* ECAP_EX03_CAPTURE_PWM_H_ */
