/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  FILE:   sdfm_ex1_filter_sync_cpuread.c
 *
 *  TITLE:  SDFM Filter sync CPU Example.
 *
 *  In this example, SDFM filter data is read by CPU in SDFM ISR routine. The
 *  SDFM configuration is shown below:
 *   -  SDFM used in this example - SDFM1
 *   -  Input control mode selected - MODE0
 *   -  Comparator settings
 *        - Sinc3 filter selected
 *        - OSR = 32
 *        - HLT = 0x7FFF (Higher threshold setting)
 *        - LLT  = 0x0000(Lower threshold setting)
 *   -  Data filter settings
 *       - All the 4 filter modules enabled
 *       - Sinc3 filter selected
 *       - OSR = 128
 *       - All the 4 filters are synchronized by using MFE
 *        (Master Filter enable bit)
 *       - Filter output represented in 16 bit format
 *       - In order to convert 25 bit Data filter
 *         into 16 bit format user needs to right shift by 7 bits for
 *         Sinc3 filter with OSR = 128
 *   - Interrupt module settings for SDFM filter
 *       - All the 4 higher threshold comparator interrupts disabled
 *       - All the 4 lower threshold comparator interrupts disabled
 *       - All the 4 modulator failure interrupts disabled
 *       - All the 4 filter data ready interrupt source is FIFO.
 *
 *  @hardware_requirements
 *  		 - Sigma-Delta Modulator : AMC3306M25   V(clipping) == 320mV
 *           - GS32MT5000&4000
 *  | External | Connections |
 *  XCLKOUT -> GPIO18 Connect to Sigma-Delta clk
 *
 *  | SDFM1 |
 *	SD1-C1 -> GPIO17 Connect to Sigma-Delta clk
 *	SD1-D1 -> GPIO16 Connect to Sigma-Delta streams
 *	SD1-C2 -> GPIO19
 *	SD1-D2 -> GPIO32 Connect to Sigma-Delta streams
 *	SD1-C3 -> GPIO21
 *	SD1-D3 -> GPIO20 Connect to Sigma-Delta streams
 *	SD1-C4 -> GPIO23
 *	SD1-D4 -> GPIO22 Connect to Sigma-Delta streams
 *
 *  | SDFM2 |
 *	SD2_C1 -> GPIO25 Connect to Sigma-Delta clk
 *	SD2_D1 -> GPIO24 Connect to Sigma-Delta streams
 *	SD2_C2 -> GPIO27
 *	SD2_D2 -> GPIO26 Connect to Sigma-Delta streams
 *	SD2_C3 -> GPIO29
 *	SD2_D3 -> GPIO28 Connect to Sigma-Delta streams
 *	SD2_C4 -> GPIO31
 *	SD2_D4 -> GPIO30 Connect to Sigma-Delta streams
 *
 *  | Watch Variables |
 *  - filter1Result - Output of filter 1
 *  - filter2Result - Output of filter 2
 *  - filter3Result - Output of filter 3
 *  - filter4Result - Output of filter 4
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"
#include "sdfm_sync_fiforead.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/* None */

/*
 * @brief  main function.
 */
int main(void)
{
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);
    printf("sdfm_ex2_filter_sync_fiforead test!\r\n");

    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_SDFM);
    pinmux_init();
    sdfm_init(SDFM_BASE);

    /* Provide a clock for the modulator */

	GPIO_setPinConfig(GPIO_18_XCLKOUT);
	SysCtl_setObsSigSel(OBS_SIG_APB_CLK);
	SysCtl_setObsSigDiv(5); // 10MHz

#if SDFM_BASE == SDFM1_BASE
	/* registration FIFO interruption */

	Interrupt_register(INT_SDFM1DR1, sdfm1_D1_FIFO_ISR);
	Interrupt_enable(INT_SDFM1DR1);

	Interrupt_register(INT_SDFM1DR2, sdfm1_D2_FIFO_ISR);
	Interrupt_enable(INT_SDFM1DR2);

	Interrupt_register(INT_SDFM1DR3, sdfm1_D3_FIFO_ISR);
	Interrupt_enable(INT_SDFM1DR3);

	Interrupt_register(INT_SDFM1DR4, sdfm1_D4_FIFO_ISR);
	Interrupt_enable(INT_SDFM1DR4);

#elif SDFM_BASE == SDFM2_BASE
	/* registration FIFO interruption */

	Interrupt_register(INT_SDFM2DR1, sdfm2_D1_FIFO_ISR);
	Interrupt_enable(INT_SDFM2DR1);

	Interrupt_register(INT_SDFM2DR2, sdfm2_D2_FIFO_ISR);
	Interrupt_enable(INT_SDFM2DR2);

	Interrupt_register(INT_SDFM2DR3, sdfm2_D3_FIFO_ISR);
	Interrupt_enable(INT_SDFM2DR3);

	Interrupt_register(INT_SDFM2DR4, sdfm2_D4_FIFO_ISR);
	Interrupt_enable(INT_SDFM2DR4);
#endif

    EINT; /* Enable Global Interrupt (INTM) */

	while(1);

    return 0;
}
