/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <stdint.h>
#include <string.h>

#include "fdp_err.h"
#include "fdp_storage_port.h"
#include "fdp_cache.h"
#include "fdp_defconfig.h"

/**
 * @brief User define include header file.
 * 
 */
#include "gs32_flashAPI_lib.h"
#include "flash_programming_gs32.h"
#include "inc/hw_flash.h"

#include "device.h"

/**
 * @brief User define macro.
 *
 */

/* Flash sector size. */
#define FLASH_SECTOR_SIZE	FlashMainPageSize

int fdp_storage_dev_init(uint32_t start_addr, uint32_t size)
{
	return FDP_SUCCESS;
}

int fdp_storage_dev_erase(uint32_t start_addr, uint32_t size)
{
	return FDP_SUCCESS;
}

int fdp_storage_dev_write(uint8_t *buffer, uint32_t start_addr, uint32_t len)
{
	memcpy((void *)(uintptr_t)start_addr, buffer, len);

	return FDP_SUCCESS;
}

int fdp_storage_dev_read(uint8_t *buffer, uint32_t start_addr, uint32_t len)
{
	if (buffer == NULL)
		return -FDP_ERRINPARAM;

	memcpy((void *)buffer, (void *)(uintptr_t)start_addr, len);

	return FDP_SUCCESS;
}

int fdp_security_mem_check(uintptr_t addr, uint32_t size)
{
	return FDP_SUCCESS;
}
