/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __FDP_DEFCONFIG_H__
#define __FDP_DEFCONFIG_H__

#include <stdbool.h>

#include "fdp_port.h"

/* Configure chip architecture. */
#define FDP_CONFIG_ARCH_RISCV					true

/* Configure FDP Receive Buffer Size and the buffer size
can not be less than device frame size. */
#define FDP_CONFIG_FRAME_BUFFER_SIZE			4096U

/* Vender ID. */
#define FDP_VENDER_NUMBER						0x9527U

/* FDP use interrupts. */
#define FDP_IS_USE_INTERRUPT					flase

/* If you need to disable interrupt when writting data
to memory device, set it to true, else false. */
#define FDP_MEM_WRITE_IS_DISABLE_INT			true

/* If you need to disable interrupt when writting data
to memory device, set it to true, else false. */
#define FDP_MEM_ERASE_IS_DISABLE_INT			true

/* If there is a minimum byte write requirement when writing memory,
the macro can be opened and must be aligned with a multiple of
the maximum number of bytes that can be supported for data packet transmission. */
#define FDP_MEM_LINE_SIZE						32U

/* Watchdog counter. If the watchdog counter reaches the value,
the watchdog timer will be reset. */
#define FDP_WATCHDOG_TIMEOUT					100000U

/* Check if the memory address is in the range of the security area. */
#define FDP_SECURITY_MEMORY_CHECK(addr, size)	fdp_security_mem_check(addr, size)

/* Enable global interrupts API. */
#define FDP_ENABLE_INTERRUPTS					fdp_globale_interrupt_enable()

/* Disable global interrupts API. */
#define FDP_DISABLE_INTERRUPTS					fdp_globale_interrupt_disable()

/* Enable/Disable check crc value of image. */
#define FDP_IS_CHECK_IMAGE_CRC32				true

/* Enable/Disable check crc value of storage erase. */
#define FDP_IS_CHECK_STORAGE_ERASE				true

/* Enable/Disable check crc value of storage write. */
#define FDP_IS_CHECK_STORAGE_WRITE				true

#define FPD_VERSION_NUMBER						0x30

#if (defined(FPD_VERSION_NUMBER) && FPD_VERSION_NUMBER == 0x30)

/* CPU cache lines. */
#define FDP_CPU_CACHE_LINES_SIZE				32U

#elif (defined(FPD_VERSION_NUMBER) && FPD_VERSION_NUMBER == 0x22)
/* CPU cache lines. */
#define FDP_CPU_CACHE_LINES_SIZE				64U

#elif (defined(FPD_VERSION_NUMBER) && FPD_VERSION_NUMBER == 0x12)

/* CPU cache lines. */
#define FDP_CPU_CACHE_LINES_SIZE				32U

#endif

#endif
