/*
 * Copyright (c) 2019 Nuclei Limited. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

OUTPUT_ARCH( "riscv" )

ENTRY( __boot_start )

MEMORY
{
	sysmem	(rxa!w) : ORIGIN = 0x1FFE0000, LENGTH = 16K
	dlm		(wxa!r) : ORIGIN = 0x20120000, LENGTH = 16K
	ilm		(wxa!r) : ORIGIN = 0x20100000, LENGTH = 64K
}

REGION_ALIAS("SYSMEM", sysmem)
REGION_ALIAS("DLM", dlm)
REGION_ALIAS("ILM", ilm)

SECTIONS
{
	/* To provide symbol __STACK_SIZE, __HEAP_SIZE and __SMP_CPU_CNT */
	PROVIDE(__STACK_SIZE = 2K);
	PROVIDE(__HEAP_SIZE = 1K);
	PROVIDE(__SMP_CPU_CNT = 1);
	__TOT_STACK_SIZE = __STACK_SIZE * __SMP_CPU_CNT;

	.init :
	{
		KEEP (*(SORT_NONE(.boot_start_init)));
		. = ALIGN(16);
	} >SYSMEM AT>SYSMEM

	.text :
	{
		. = ALIGN(4);
		__start_text__ = .;
		*(.text.unlikely .text.unlikely.*)
		*(.text.startup .text.startup.*)
		*(.text .text.*)
		*(.boot_text_section)
		*(.boot_gpio_section)
		*(.gnu.linkonce.t.*)
		__end_text__ = .;
		. = ALIGN(16);
	} >SYSMEM AT>SYSMEM

	.ilm :
	{
		. = ALIGN(4);
		*(.RamFunc .RamFunc.*)
		*(.IlmFunc .Ilmfunc.*)
		*(.boot_rom_to_ram_section)
		*(.boot_flash_sec .boot_flash_sec.*)
		. = ALIGN(16);
	} >ILM AT>SYSMEM

	.data :
	{
		. = ALIGN(8);
		KEEP(*(.data.ctest*))
		KEEP(*(.data.ctest*))
		*(.data .data.*)
		*(.gnu.linkonce.d.*)
		. = ALIGN(8);
		PROVIDE( __global_pointer$ = . + 0x800 );
		*(.sdata .sdata.* .sdata*)
		*(.gnu.linkonce.s.*)
		/* readonly data placed in RAM for access speed */
		. = ALIGN(8);
		*(.srodata.cst16)
		*(.srodata.cst8)
		*(.srodata.cst4)
		*(.srodata.cst2)
		*(.srodata .srodata.*)
		*(.rdata)
		*(.rodata .rodata.*)
		*(.gnu.linkonce.r.*)
		/* below sections are used for rt-thread */
		. = ALIGN(4);
		__rt_init_start = .;
		KEEP(*(SORT(.rti_fn*)))
		__rt_init_end = .;
		. = ALIGN(4);
		__fsymtab_start = .;
		KEEP(*(FSymTab))
		__fsymtab_end = .;
		. = ALIGN(4);
		__vsymtab_start = .;
		KEEP(*(VSymTab))
		__vsymtab_end = .;
		. = ALIGN(16);
	} >DLM AT>SYSMEM

	.tdata :
	{
		. = ALIGN(8);
		PROVIDE( __tls_base = . );
		*(.tdata .tdata.* .gnu.linkonce.td.*)
		. = ALIGN(16);
	} >DLM AT>SYSMEM

	.bss (NOLOAD):
	{
		. = ALIGN(8);
		__start_bss__ = .;
		*(.sbss*)
		*(.gnu.linkonce.sb.*)
		*(.bss .bss.*)
		*(.gnu.linkonce.b.*)
		*(COMMON)
		*(.boot_bss_section)
		. = ALIGN(4);
		__end_bss__ = .;
	} >DLM AT>DLM

	.copy.table :
	{
		. = ALIGN(4);
		__copy_table_start = .;

		LONG (LOADADDR(.data))
		LONG (ADDR(.data))
		LONG (SIZEOF(.data) / 4)

		LONG (LOADADDR(.tdata))
		LONG (ADDR(.tdata))
		LONG (SIZEOF(.tdata) / 4)

		LONG (LOADADDR(.ilm))
		LONG (ADDR(.ilm))
		LONG (SIZEOF(.ilm) / 4)

		__copy_table_end = .;
		. = ALIGN(16);
	} > SYSMEM

	.zero.table :
	{
		. = ALIGN(4);
		__zero_table_start = .;

		LONG (ADDR(.bss))
		LONG (SIZEOF(.bss) / 4)

		__zero_table_end = .;
		. = ALIGN(16);
	} > SYSMEM

	/* Nuclei C Runtime Library requirements:
	* 1. heap need to be align at 16 bytes
	* 2. __heap_start and __heap_end symbol need to be defined
	* 3. reserved at least __HEAP_SIZE space for heap
	*/
	.heap (NOLOAD) : ALIGN(16)
	{
		. = ALIGN(16);
		PROVIDE( __heap_start = . );
		. += __HEAP_SIZE;
		. = ALIGN(16);
		PROVIDE( __heap_limit = . );
	} >DLM AT>DLM

	.stack ORIGIN(DLM) + LENGTH(DLM) - __TOT_STACK_SIZE (NOLOAD) :
	{
		. = ALIGN(16);
		PROVIDE( _heap_end = . );
		PROVIDE( __heap_end = . );
		PROVIDE( __StackLimit = . );
		PROVIDE( __StackBottom = . );
		. += __TOT_STACK_SIZE;
		. = ALIGN(16);
		PROVIDE( __StackTop = . );
		PROVIDE( _sp = . );
	} >DLM AT>DLM
}
