/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


#ifndef BROM_BOOT_MODES_H
#define BROM_BOOT_MODES_H

#include <string.h>
#include "bootrom.h"

//
// BootROM System Clock (10MHz)
//
#define BOOTROM_SYSCLK         10000000UL

//
// Boot Mode Values
//
#define PARALLEL_BOOT           0x00U
#define PARALLEL_BOOT_ALT1      0x20U

#define SCI_BOOT                0x01U   //GPIO29; GPIO28 (CCARD)
#define SCI_BOOT_ALT1           0x21U   //GPIO16; GPIO17
#define SCI_BOOT_ALT2           0x41U   //GPIO8;  GPIO9
#define SCI_BOOT_ALT3           0x61U   //GPIO2;  GPIO3
#define SCI_BOOT_ALT4           0x81U   //GPIO16; GPIO3

#define CAN_BOOT                0x02U   //GPIO4; GPIO5
#define CAN_BOOT_ALT1           0x22U   //GPIO32; GPIO33
#define CAN_BOOT_ALT2           0x42U   //GPIO2; GPIO3
#define CAN_BOOT_ALT3           0x62U   //GPIO13, GPIO12
#define CAN_BOOT_SENDTEST       0x82U   //GPIO4; GPIO5
#define CAN_BOOT_ALT1_SENDTEST  0xA2U   //GPIO32; GPIO33
#define CAN_BOOT_ALT2_SENDTEST  0xC2U   //GPIO2; GPIO3
#define CAN_BOOT_ALT3_SENDTEST  0xE2U   //GPIO13, GPIO12

#define FLASH_BOOT              0x03U   //BANK0 sector 0
#define FLASH_BOOT_ALT1         0x23U   //BANK0 sector 8
#define FLASH_BOOT_ALT2         0x43U   //BANK0 end of sector 15
#define FLASH_BOOT_ALT3         0x63U   //BANK1 sector 0
#define FLASH_BOOT_ALT4         0x83U   //BANK1 end of sector 7
#define FLASH_BOOT_ALT5         0xA3U   //BANK1 end of sector 15
#define FLASH_BOOT_ALT6         0xC3U   //BANK2 sector 0
#define FLASH_BOOT_ALT7         0xE3U   //BANK2 end of sector 15

#define WAIT_BOOT               0x04U   //with WDOG enabled
#define WAIT_BOOT_ALT1          0x24U   //without WDOG enabled

#define RAM_BOOT                0x05U

#define SPI_MASTER_BOOT         0x06U   //GPIO 2,1,3,5
#define SPI_MASTER_BOOT_ALT1    0x26U   //GPIO 16,1,3,0
#define SPI_MASTER_BOOT_ALT2    0x46U   //GPIO 8,10,9,11
#define SPI_MASTER_BOOT_ALT3    0x66U   //GPIO 8,17,9,11

#define I2C_MASTER_BOOT         0x07U   //GPIO32(SDA), GPIO33(SCL)
#define I2C_MASTER_BOOT_ALT1    0x27U   //GPIO0 (SDA), GPIO1 (SCL)
#define I2C_MASTER_BOOT_ALT2    0x47U   //GPIO10(SDA), GPIO8 (SCL)

#define MCAN_BOOT                0x08U   //GPIO4 (Tx); GPIO5 (Rx)
#define MCAN_BOOT_ALT1           0x28U   //GPIO1 (Tx); GPIO0 (Rx)
#define MCAN_BOOT_ALT2           0x48U   //GPIO13 (Tx); GPIO12 (Rx)
#define MCAN_BOOT_SENDTEST       0x68U   //GPIO4 (Tx); GPIO5 (Rx)
#define MCAN_BOOT_ALT1_SENDTEST  0x88U   //GPIO0 (Tx); GPIO1 (Rx)
#define MCAN_BOOT_ALT2_SENDTEST  0xA8U   //GPIO13 (Tx); GPIO12 (Rx)

//
// Secure Flash Boot Options
//
#define SECURE_FLASH_BOOT               0x0AU    //BANK0 sector 0
#define SECURE_FLASH_BOOT_ALT1          0x2AU    //BANK0 sector 8
#define SECURE_FLASH_BOOT_ALT2          0x4AU    //BANK0 end of sector 15
#define SECURE_FLASH_BOOT_ALT3          0x6AU    //BANK1 sector 0
#define SECURE_FLASH_BOOT_ALT4          0x8AU    //BANK1 end of sector 7
#define SECURE_FLASH_BOOT_ALT5          0xAAU    //BANK1 end of sector 15
#define SECURE_FLASH_BOOT_ALT6          0xCAU    //BANK2 sector 0

//
// LFU Flash Boot Options
//
#define LFU_FLASH_BOOT                  0x0BU
#define LFU_FLASH_BOOT_ALT1             0x2BU
#define LFU_FLASH_BOOT_ALT2             0x4BU
#define LFU_FLASH_BOOT_ALT3             0x6BU
#define LFU_FLASH_BOOT_ALT4             0x8BU

//
// Entry Addresses
//
#define FLASH_ENTRY_POINT       0x08000000UL


//
// Misc
//
#define BROM_EIGHT_BIT_HEADER   0x08AAU



extern uint32_t UART_BASE_ADDRESS;

//
// Bootloader function pointer
//
typedef uint16_t (*uint16fptr)(void);
extern  uint16fptr GetWordData;

//
// Function Prototypes
//
extern uint32_t GetLongData(void);
extern void CopyData(void);
extern void ReadReservedFn(void);
extern uint16_t BROM_decodeBootPins(uint32_t pinConfig);
extern uint32_t BROM_getStandaloneBootMode(uint32_t z2OTPBootpinCfgKey, uint32_t z1OTPBootpinCfgKey);
#endif //C_BOOTROM_H_
