/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#if __riscv

#include "riscv_encoding.h"

	.section .boot_start_init , "ax"
	.globl __boot_start
	.type __boot_start, @function

__boot_start:
	 /* Disable Global Interrupt */
	csrc CSR_MSTATUS, MSTATUS_MIE

	/*enable nice instruction*/
	lui	a5,0x18
	csrs	mstatus, a5

	/* Set correct sp for current cpu */
	la sp, _sp

	/*
	 * Set the the NMI base mnvec to share
	 * with mtvec by setting CSR_MMISC_CTL
	 * bit 9 NMI_CAUSE_FFF to 1
	 */
	li t0, MMISC_CTL_NMI_CAUSE_FFF
	csrs CSR_MMISC_CTL, t0

	la t0, __boot_vector_remap_start__
	csrw CSR_MTVT, t0

	/*
	 * Set ECLIC non-vector entry to be controlled
	 * by mtvt2 CSR register.
	 * Intialize ECLIC non-vector interrupt
	 * base address mtvt2 to boot_irq_entry.
	 */
	la t0, boot_irq_entry
	csrw CSR_MTVT2, t0
	csrs CSR_MTVT2, 0x1

	/*
	 * Set Exception Entry MTVEC to boot_exc_entry
	 * Due to settings above, Exception and NMI
	 * will share common entry.
	 * This boot_exc_entry is only used during early
	 * boot stage before main
	 */
	 la t0, boot_exc_entry
	 csrw CSR_MTVEC, t0

	/* Set the interrupt processing mode to ECLIC mode */
	li t0, 0x3f
	csrc CSR_MTVEC, t0
	csrs CSR_MTVEC, 0x3

	/* Enable FPU and Vector Unit if f/d/v exist in march */
#if defined(__riscv_flen) && __riscv_flen > 0
	/* Enable FPU, and set state to initial */
	li t0, MSTATUS_FS
	csrc mstatus, t0
	li t0, MSTATUS_FS_INITIAL
	csrs mstatus, t0
#endif

#if defined(__riscv_vector)
	/* Enable Vector, and set state to initial */
	li t0, MSTATUS_VS
	csrc mstatus, t0
	li t0, MSTATUS_VS_INITIAL
	csrs mstatus, t0
#endif

	/* Enable mcycle and minstret counter */
	csrci CSR_MCOUNTINHIBIT, 0x5

	/* copy data from LMA to VMA */
	la a4, __boot_copy_table_start
	la a5, __boot_copy_table_end

1:  bgeu a4, a5, 3f
	lw a0, (a4)			/* LMA */
	lw a1, 4(a4)		/* VMA */
	lw a2, 8(a4)		/* Length */
	addi a4, a4, 12

	beq a0, a1, 1b		/* LMA == VMA ? */
	beq a2, zero, 1b	/* Length == 0 ? */
2:
	lw t0, (a0)
	sw t0, (a1)
	addi a0, a0, 4
	addi a1, a1, 4
	addi a2, a2, -1
	bne a2, zero, 2b
	j 1b
3:

	/* zero data */
	la a4, __boot_zero_table_start
	la a5, __boot_zero_table_end

1:
	bgeu a4, a5, 3f
	lw a0, (a4)			/* start */
	lw a2, 4(a4)		/* length */
	addi a4, a4, 8

	beq a2, zero, 1b
2:
	sw zero, (a0)
	addi a0, a0, 4
	addi a2, a2, -1
	bne a2, zero, 2b
	j 1b
3:

	li a0, 0
	li a1, 0
	call __boot_main

waitting :
	wfi
	j waitting

#endif	/* __riscv */
