/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __BOOT_ASYSCTL_V3_0_H__
#define __BOOT_ASYSCTL_V3_0_H__

#ifdef __cplusplus
extern "C"{
#endif

#if (GS32F00xx == 0x3000)

#include "boot_hw_type.h"
#include "inc/hw_memmap.h"
#include "inc/hw_asysctl_v30.h"

/* ANA_OSC2_SPARE OSC2 Config Register Offset 0x328
 *
 * Register Field		Field Range
 * ana_top_spare		31:11
 * freq_sel				10:9
 * ldo trim				5:2
 * test_vol_sel			1	0:ldo_vref, 1:ldo_vout
 * test_en				0
*/
typedef enum Boot_OSC2_Freq_Sel {
	BOOT_OSC2_FREQ_HIGH = 2,		/* ~10MHz */
	BOOT_OSC2_FREQ_MID = 0,			/* ~5MHz */
	BOOT_OSC2_FREQ_LOW = 1,			/* ~4MHz */
} Boot_OSC2_Freq_Sel_t;

BOOT_TEXT void boot_sysctl_set_osc2_freq_range(Boot_OSC2_Freq_Sel_t val);

BOOT_TEXT void boot_sysctl_set_osc1_trim(void);

BOOT_TEXT void boot_sysctl_set_osc2_coarse_internal_trim(void);

BOOT_TEXT void boot_sysctl_set_osc2_fine_internal_trim(void);

BOOT_TEXT void boot_sysctl_set_top_ldo_1v2_trim(void);

BOOT_TEXT void boot_sysctl_set_ana_ldo_trim(void);

#endif

#ifdef __cplusplus
}
#endif

#endif
